/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.ProductVariantService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.businessproduction.service.OperationOrderServiceBusinessImpl;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.db.repo.ProdProductRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.manuforder.ManufOrderServiceImpl;
import com.axelor.apps.production.service.manuforder.ManufOrderWorkflowService;
import com.axelor.apps.production.service.operationorder.OperationOrderService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManufOrderServiceBusinessImpl
extends ManufOrderServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected OperationOrderServiceBusinessImpl operationOrderServiceBusinessImpl;

    @Inject
    public ManufOrderServiceBusinessImpl(SequenceService sequenceService, OperationOrderService operationOrderService, ManufOrderWorkflowService manufOrderWorkflowService, ProductVariantService productVariantService, AppBaseService appBaseService, AppProductionService appProductionService, ManufOrderRepository manufOrderRepo, ProdProductRepository prodProductRepo, OperationOrderServiceBusinessImpl operationOrderServiceBusinessImpl, ProductCompanyService productCompanyService) {
        super(sequenceService, operationOrderService, manufOrderWorkflowService, productVariantService, appBaseService, appProductionService, manufOrderRepo, prodProductRepo, productCompanyService);
        this.operationOrderServiceBusinessImpl = operationOrderServiceBusinessImpl;
    }

    @Transactional
    public void propagateIsToInvoice(ManufOrder manufOrder) {
        this.logger.debug("{} is to invoice ? {}", (Object)manufOrder.getManufOrderSeq(), (Object)manufOrder.getIsToInvoice());
        boolean isToInvoice = manufOrder.getIsToInvoice();
        if (manufOrder.getOperationOrderList() != null) {
            for (OperationOrder operationOrder : manufOrder.getOperationOrderList()) {
                operationOrder.setIsToInvoice(isToInvoice);
            }
        }
        this.manufOrderRepo.save((Model)((Object)manufOrder));
    }

    public ManufOrder createManufOrder(Product product, BigDecimal qty, int priority, boolean isToInvoice, Company company, BillOfMaterial billOfMaterial, LocalDateTime plannedStartDateT, LocalDateTime plannedEndDateT) throws AxelorException {
        ManufOrder manufOrder = super.createManufOrder(product, qty, priority, isToInvoice, company, billOfMaterial, plannedStartDateT, plannedEndDateT);
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            return manufOrder;
        }
        manufOrder.setIsToInvoice(isToInvoice);
        return manufOrder;
    }
}

