/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdHumanResource;
import com.axelor.apps.production.db.ProdProcessLine;
import com.axelor.apps.production.db.WorkCenter;
import com.axelor.apps.production.db.repo.OperationOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.operationorder.OperationOrderServiceImpl;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationOrderServiceBusinessImpl
extends OperationOrderServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Transactional(rollbackOn={Exception.class})
    public OperationOrder createOperationOrder(ManufOrder manufOrder, ProdProcessLine prodProcessLine) throws AxelorException {
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            return super.createOperationOrder(manufOrder, prodProcessLine);
        }
        OperationOrder operationOrder = this.createOperationOrder(manufOrder, prodProcessLine.getPriority(), manufOrder.getIsToInvoice(), prodProcessLine.getWorkCenter(), prodProcessLine.getWorkCenter(), prodProcessLine);
        return (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).save((Model)((Object)operationOrder)));
    }

    @Transactional
    public OperationOrder createOperationOrder(ManufOrder manufOrder, int priority, boolean isToInvoice, WorkCenter workCenter, WorkCenter machineWorkCenter, ProdProcessLine prodProcessLine) {
        this.logger.debug("Cr\u00e9ation d'une op\u00e9ration {} pour l'OF {}", (Object)priority, (Object)manufOrder.getManufOrderSeq());
        String operationName = prodProcessLine.getName();
        OperationOrder operationOrder = new OperationOrder(priority, this.computeName(manufOrder, priority, operationName), operationName, manufOrder, workCenter, machineWorkCenter, 1, prodProcessLine);
        operationOrder.setIsToInvoice(isToInvoice);
        this._createHumanResourceList(operationOrder, machineWorkCenter);
        return (OperationOrder)((Object)((OperationOrderRepository)((Object)Beans.get(OperationOrderRepository.class))).save((Model)((Object)operationOrder)));
    }

    protected ProdHumanResource copyProdHumanResource(ProdHumanResource prodHumanResource) {
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            return super.copyProdHumanResource(prodHumanResource);
        }
        ProdHumanResource prodHumanResourceCopy = new ProdHumanResource(prodHumanResource.getProduct(), prodHumanResource.getDuration());
        prodHumanResourceCopy.setEmployee(prodHumanResource.getEmployee());
        return prodHumanResourceCopy;
    }
}

