/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.db.repo.ProductionOrderRepository;
import com.axelor.apps.production.service.manuforder.ManufOrderService;
import com.axelor.apps.production.service.productionorder.ProductionOrderServiceImpl;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDateTime;

public class ProductionOrderServiceBusinessImpl
extends ProductionOrderServiceImpl {
    @Inject
    public ProductionOrderServiceBusinessImpl(ManufOrderService manufOrderService, SequenceService sequenceService, ProductionOrderRepository productionOrderRepo) {
        super(manufOrderService, sequenceService, productionOrderRepo);
    }

    @Transactional(rollbackOn={Exception.class})
    public ProductionOrder generateProductionOrder(Product product, BillOfMaterial billOfMaterial, BigDecimal qtyRequested, Project project, LocalDateTime startDate, LocalDateTime endDate, SaleOrder saleOrder) throws AxelorException {
        ProductionOrder productionOrder = this.createProductionOrder(saleOrder);
        productionOrder.setProject(project);
        this.addManufOrder(productionOrder, product, billOfMaterial, qtyRequested, startDate, endDate, saleOrder, 3);
        return (ProductionOrder)((Object)this.productionOrderRepo.save((Model)((Object)productionOrder)));
    }
}

