/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.businessproduction.service.ProductionOrderServiceBusinessImpl;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.production.db.repo.BillOfMaterialRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.apps.production.service.productionorder.ProductionOrderService;
import com.axelor.apps.production.service.productionorder.ProductionOrderWizardServiceImpl;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.Context;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductionOrderWizardServiceBusinessImpl
extends ProductionOrderWizardServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ProductionOrderServiceBusinessImpl productionOrderServiceBusinessImpl;

    @Inject
    public ProductionOrderWizardServiceBusinessImpl(ProductionOrderService productionOrderService, BillOfMaterialRepository billOfMaterialRepo, ProductRepository productRepo, AppProductionService appProductionService, ProductionOrderServiceBusinessImpl productionOrderServiceBusinessImpl) {
        super(productionOrderService, billOfMaterialRepo, productRepo, appProductionService);
        this.productionOrderServiceBusinessImpl = productionOrderServiceBusinessImpl;
    }

    public Long validate(Context context) throws AxelorException {
        ProductionOrder productionOrder;
        AppProductionService appProductionService = (AppProductionService)Beans.get(AppProductionService.class);
        if (!appProductionService.isApp("production") || !appProductionService.getAppProduction().getManageBusinessProduction().booleanValue()) {
            return super.validate(context);
        }
        Map bomContext = (Map)context.get((Object)"billOfMaterial");
        BillOfMaterial billOfMaterial = (BillOfMaterial)this.billOfMaterialRepo.find(Long.valueOf(((Integer)bomContext.get("id")).longValue()));
        BigDecimal qty = new BigDecimal((String)context.get((Object)"qty"));
        Product product = null;
        if (context.get((Object)"product") != null) {
            Map productContext = (Map)context.get((Object)"product");
            product = (Product)((Object)this.productRepo.find(((Integer)productContext.get("id")).longValue()));
        } else {
            product = billOfMaterial.getProduct();
        }
        ZonedDateTime endDateT = null;
        ZonedDateTime startDateT = context.containsKey((Object)"_startDate") && context.get((Object)"_startDate") != null ? ZonedDateTime.parse(context.get((Object)"_startDate").toString(), DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault())) : appProductionService.getTodayDateTime();
        if (context.containsKey((Object)"_endDate") && context.get((Object)"_endDate") != null) {
            endDateT = ZonedDateTime.parse(context.get((Object)"_endDate").toString(), DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.systemDefault()));
        }
        Project project = null;
        if (context.get((Object)"business_id") != null) {
            project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(((Integer)context.get((Object)"business_id")).longValue()));
        }
        if ((productionOrder = this.productionOrderServiceBusinessImpl.generateProductionOrder(product, billOfMaterial, qty, project, startDateT.toLocalDateTime(), endDateT != null ? endDateT.toLocalDateTime() : null, null)) != null) {
            return productionOrder.getId();
        }
        throw new AxelorException(4, I18n.get((String)"Error during production's order's creation"));
    }
}

