/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.businessproduction.web;

import com.axelor.apps.businessproduction.service.ManufOrderServiceBusinessImpl;
import com.axelor.apps.businessproduction.service.ManufOrderValidateBusinessService;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.production.db.repo.ManufOrderRepository;
import com.axelor.apps.production.service.app.AppProductionService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ManufOrderBusinessController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void propagateIsToInvoice(ActionRequest request, ActionResponse response) {
        ManufOrderServiceBusinessImpl manufOrderService = (ManufOrderServiceBusinessImpl)((Object)Beans.get(ManufOrderServiceBusinessImpl.class));
        ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
        manufOrderService.propagateIsToInvoice((ManufOrder)((Object)((ManufOrderRepository)((Object)Beans.get(ManufOrderRepository.class))).find(manufOrder.getId())));
        response.setReload(true);
    }

    public void alertNonValidatedTimesheet(ActionRequest request, ActionResponse response) {
        try {
            ManufOrder manufOrder = (ManufOrder)((Object)request.getContext().asType(ManufOrder.class));
            if (((AppProductionService)Beans.get(AppProductionService.class)).getAppProduction().getEnableTimesheetOnManufOrder().booleanValue() && ((ManufOrderValidateBusinessService)Beans.get(ManufOrderValidateBusinessService.class)).checkTimesheet(manufOrder) > 0L) {
                response.setAlert(I18n.get((String)"There are timesheet still waiting validation on this manuf order, do you want to continue anyway ?"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

