/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.production.db.BillOfMaterial;
import com.axelor.apps.production.db.CostSheet;
import com.axelor.apps.production.db.OperationOrder;
import com.axelor.apps.production.db.ProdProcess;
import com.axelor.apps.production.db.ProdProduct;
import com.axelor.apps.production.db.ProductionOrder;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PRODUCTION_MANUF_ORDER", uniqueConstraints={@UniqueConstraint(columnNames={"manufOrderSeq", "company"})}, indexes={@Index(columnList="production_order"), @Index(columnList="company"), @Index(columnList="client_partner"), @Index(columnList="sale_order"), @Index(columnList="manufOrderSeq"), @Index(columnList="unit"), @Index(columnList="bill_of_material"), @Index(columnList="product"), @Index(columnList="prod_process"), @Index(columnList="workshop_stock_location"), @Index(columnList="waste_stock_move"), @Index(columnList="cancel_reason")})
@Track(fields={@TrackField(name="qty"), @TrackField(name="prioritySelect"), @TrackField(name="plannedStartDateT"), @TrackField(name="plannedEndDateT"), @TrackField(name="clientPartner"), @TrackField(name="saleOrder"), @TrackField(name="statusSelect"), @TrackField(name="cancelReasonStr")})
public class ManufOrder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_MANUF_ORDER_SEQ")
    @SequenceGenerator(name="PRODUCTION_MANUF_ORDER_SEQ", sequenceName="PRODUCTION_MANUF_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Production order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProductionOrder productionOrder;
    @Widget(title="Operation orders")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="manufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="priority")
    private List<OperationOrder> operationOrderList;
    @Widget(title="Qty")
    @Digits(integer=10, fraction=10)
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Sale order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="MO")
    @NameColumn
    private String manufOrderSeq;
    @Widget(title="Priority", selection="production.order.priority.select")
    private Integer prioritySelect = 2;
    private Boolean isPermanent = Boolean.FALSE;
    @Widget(title="Products to consume")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="toConsumeManufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdProduct> toConsumeProdProductList;
    @Widget(title="Consumed products")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="consumedManufOrder", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<StockMoveLine> consumedStockMoveLineList;
    @Widget(title="Difference")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="diffConsumeManufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdProduct> diffConsumeProdProductList;
    @Widget(title="Products to produce")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="toProduceManufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdProduct> toProduceProdProductList;
    @Widget(title="Produced products")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="producedManufOrder", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<StockMoveLine> producedStockMoveLineList;
    @Widget(title="Waste")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="wasteManufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProdProduct> wasteProdProductList;
    @Widget(title="Manage consumed products on operations")
    private Boolean isConsProOnOperation = Boolean.FALSE;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="BoM")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BillOfMaterial billOfMaterial;
    @Widget(title="Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Cost sheet")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="manufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CostSheet> costSheetList;
    @Widget(title="Cost price")
    @Digits(integer=10, fraction=10)
    private BigDecimal costPrice = BigDecimal.ZERO;
    @Widget(title="Production process")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ProdProcess prodProcess;
    @Widget(title="Planned start date")
    private LocalDateTime plannedStartDateT;
    @Widget(title="Planned end date")
    private LocalDateTime plannedEndDateT;
    @Widget(title="Workshop")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockLocation workshopStockLocation;
    @Widget(title="Real start date")
    private LocalDateTime realStartDateT;
    @Widget(title="Real end date")
    private LocalDateTime realEndDateT;
    @Widget(title="Time difference (Minutes)")
    private BigDecimal endTimeDifference = BigDecimal.ZERO;
    @Widget(title="Stock moves in")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="inManufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockMove> inStockMoveList;
    @Widget(title="Stock moves out")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="outManufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<StockMove> outStockMoveList;
    @Widget(title="Waste stock move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private StockMove wasteStockMove;
    @Widget(title="Waste description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String wasteProdDescription;
    @Widget(title="Status", selection="production.manuf.order.status.select")
    private Integer statusSelect = 0;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String note;
    @Widget(title="Cancel reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CancelReason cancelReason;
    @Widget(title="Cancel Reason")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String cancelReasonStr;
    @Widget(title="MO's comment from sale order")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String moCommentFromSaleOrder;
    @Widget(readonly=true)
    private Boolean invoiced = Boolean.FALSE;
    @Widget(title="To Invoice")
    private Boolean isToInvoice = Boolean.FALSE;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="manufOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TimesheetLine> timesheetLine;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ManufOrder() {
    }

    public ManufOrder(BigDecimal qty, Company company, String manufOrderSeq, Integer prioritySelect, Boolean isConsProOnOperation, BillOfMaterial billOfMaterial, Product product, ProdProcess prodProcess, LocalDateTime plannedStartDateT, LocalDateTime plannedEndDateT, Integer statusSelect) {
        this.qty = qty;
        this.company = company;
        this.manufOrderSeq = manufOrderSeq;
        this.prioritySelect = prioritySelect;
        this.isConsProOnOperation = isConsProOnOperation;
        this.billOfMaterial = billOfMaterial;
        this.product = product;
        this.prodProcess = prodProcess;
        this.plannedStartDateT = plannedStartDateT;
        this.plannedEndDateT = plannedEndDateT;
        this.statusSelect = statusSelect;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ProductionOrder getProductionOrder() {
        return this.productionOrder;
    }

    public void setProductionOrder(ProductionOrder productionOrder) {
        this.productionOrder = productionOrder;
    }

    public List<OperationOrder> getOperationOrderList() {
        return this.operationOrderList;
    }

    public void setOperationOrderList(List<OperationOrder> operationOrderList) {
        this.operationOrderList = operationOrderList;
    }

    public void addOperationOrderListItem(OperationOrder item) {
        if (this.getOperationOrderList() == null) {
            this.setOperationOrderList(new ArrayList<OperationOrder>());
        }
        this.getOperationOrderList().add(item);
        item.setManufOrder(this);
    }

    public void removeOperationOrderListItem(OperationOrder item) {
        if (this.getOperationOrderList() == null) {
            return;
        }
        this.getOperationOrderList().remove((Object)item);
    }

    public void clearOperationOrderList() {
        if (this.getOperationOrderList() != null) {
            this.getOperationOrderList().clear();
        }
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public String getManufOrderSeq() {
        return this.manufOrderSeq;
    }

    public void setManufOrderSeq(String manufOrderSeq) {
        this.manufOrderSeq = manufOrderSeq;
    }

    public Integer getPrioritySelect() {
        return this.prioritySelect == null ? 0 : this.prioritySelect;
    }

    public void setPrioritySelect(Integer prioritySelect) {
        this.prioritySelect = prioritySelect;
    }

    public Boolean getIsPermanent() {
        return this.isPermanent == null ? Boolean.FALSE : this.isPermanent;
    }

    public void setIsPermanent(Boolean isPermanent) {
        this.isPermanent = isPermanent;
    }

    public List<ProdProduct> getToConsumeProdProductList() {
        return this.toConsumeProdProductList;
    }

    public void setToConsumeProdProductList(List<ProdProduct> toConsumeProdProductList) {
        this.toConsumeProdProductList = toConsumeProdProductList;
    }

    public void addToConsumeProdProductListItem(ProdProduct item) {
        if (this.getToConsumeProdProductList() == null) {
            this.setToConsumeProdProductList(new ArrayList<ProdProduct>());
        }
        this.getToConsumeProdProductList().add(item);
        item.setToConsumeManufOrder(this);
    }

    public void removeToConsumeProdProductListItem(ProdProduct item) {
        if (this.getToConsumeProdProductList() == null) {
            return;
        }
        this.getToConsumeProdProductList().remove(item);
    }

    public void clearToConsumeProdProductList() {
        if (this.getToConsumeProdProductList() != null) {
            this.getToConsumeProdProductList().clear();
        }
    }

    public List<StockMoveLine> getConsumedStockMoveLineList() {
        return this.consumedStockMoveLineList;
    }

    public void setConsumedStockMoveLineList(List<StockMoveLine> consumedStockMoveLineList) {
        this.consumedStockMoveLineList = consumedStockMoveLineList;
    }

    public void addConsumedStockMoveLineListItem(StockMoveLine item) {
        if (this.getConsumedStockMoveLineList() == null) {
            this.setConsumedStockMoveLineList(new ArrayList<StockMoveLine>());
        }
        this.getConsumedStockMoveLineList().add(item);
        item.setConsumedManufOrder(this);
    }

    public void removeConsumedStockMoveLineListItem(StockMoveLine item) {
        if (this.getConsumedStockMoveLineList() == null) {
            return;
        }
        this.getConsumedStockMoveLineList().remove((Object)item);
        item.setConsumedManufOrder(null);
    }

    public void clearConsumedStockMoveLineList() {
        if (this.getConsumedStockMoveLineList() != null) {
            for (StockMoveLine item : this.getConsumedStockMoveLineList()) {
                item.setConsumedManufOrder(null);
            }
            this.getConsumedStockMoveLineList().clear();
        }
    }

    public List<ProdProduct> getDiffConsumeProdProductList() {
        return this.diffConsumeProdProductList;
    }

    public void setDiffConsumeProdProductList(List<ProdProduct> diffConsumeProdProductList) {
        this.diffConsumeProdProductList = diffConsumeProdProductList;
    }

    public void addDiffConsumeProdProductListItem(ProdProduct item) {
        if (this.getDiffConsumeProdProductList() == null) {
            this.setDiffConsumeProdProductList(new ArrayList<ProdProduct>());
        }
        this.getDiffConsumeProdProductList().add(item);
        item.setDiffConsumeManufOrder(this);
    }

    public void removeDiffConsumeProdProductListItem(ProdProduct item) {
        if (this.getDiffConsumeProdProductList() == null) {
            return;
        }
        this.getDiffConsumeProdProductList().remove(item);
    }

    public void clearDiffConsumeProdProductList() {
        if (this.getDiffConsumeProdProductList() != null) {
            this.getDiffConsumeProdProductList().clear();
        }
    }

    public List<ProdProduct> getToProduceProdProductList() {
        return this.toProduceProdProductList;
    }

    public void setToProduceProdProductList(List<ProdProduct> toProduceProdProductList) {
        this.toProduceProdProductList = toProduceProdProductList;
    }

    public void addToProduceProdProductListItem(ProdProduct item) {
        if (this.getToProduceProdProductList() == null) {
            this.setToProduceProdProductList(new ArrayList<ProdProduct>());
        }
        this.getToProduceProdProductList().add(item);
        item.setToProduceManufOrder(this);
    }

    public void removeToProduceProdProductListItem(ProdProduct item) {
        if (this.getToProduceProdProductList() == null) {
            return;
        }
        this.getToProduceProdProductList().remove(item);
    }

    public void clearToProduceProdProductList() {
        if (this.getToProduceProdProductList() != null) {
            this.getToProduceProdProductList().clear();
        }
    }

    public List<StockMoveLine> getProducedStockMoveLineList() {
        return this.producedStockMoveLineList;
    }

    public void setProducedStockMoveLineList(List<StockMoveLine> producedStockMoveLineList) {
        this.producedStockMoveLineList = producedStockMoveLineList;
    }

    public void addProducedStockMoveLineListItem(StockMoveLine item) {
        if (this.getProducedStockMoveLineList() == null) {
            this.setProducedStockMoveLineList(new ArrayList<StockMoveLine>());
        }
        this.getProducedStockMoveLineList().add(item);
        item.setProducedManufOrder(this);
    }

    public void removeProducedStockMoveLineListItem(StockMoveLine item) {
        if (this.getProducedStockMoveLineList() == null) {
            return;
        }
        this.getProducedStockMoveLineList().remove((Object)item);
        item.setProducedManufOrder(null);
    }

    public void clearProducedStockMoveLineList() {
        if (this.getProducedStockMoveLineList() != null) {
            for (StockMoveLine item : this.getProducedStockMoveLineList()) {
                item.setProducedManufOrder(null);
            }
            this.getProducedStockMoveLineList().clear();
        }
    }

    public List<ProdProduct> getWasteProdProductList() {
        return this.wasteProdProductList;
    }

    public void setWasteProdProductList(List<ProdProduct> wasteProdProductList) {
        this.wasteProdProductList = wasteProdProductList;
    }

    public void addWasteProdProductListItem(ProdProduct item) {
        if (this.getWasteProdProductList() == null) {
            this.setWasteProdProductList(new ArrayList<ProdProduct>());
        }
        this.getWasteProdProductList().add(item);
        item.setWasteManufOrder(this);
    }

    public void removeWasteProdProductListItem(ProdProduct item) {
        if (this.getWasteProdProductList() == null) {
            return;
        }
        this.getWasteProdProductList().remove(item);
    }

    public void clearWasteProdProductList() {
        if (this.getWasteProdProductList() != null) {
            this.getWasteProdProductList().clear();
        }
    }

    public Boolean getIsConsProOnOperation() {
        return this.isConsProOnOperation == null ? Boolean.FALSE : this.isConsProOnOperation;
    }

    public void setIsConsProOnOperation(Boolean isConsProOnOperation) {
        this.isConsProOnOperation = isConsProOnOperation;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public BillOfMaterial getBillOfMaterial() {
        return this.billOfMaterial;
    }

    public void setBillOfMaterial(BillOfMaterial billOfMaterial) {
        this.billOfMaterial = billOfMaterial;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public List<CostSheet> getCostSheetList() {
        return this.costSheetList;
    }

    public void setCostSheetList(List<CostSheet> costSheetList) {
        this.costSheetList = costSheetList;
    }

    public void addCostSheetListItem(CostSheet item) {
        if (this.getCostSheetList() == null) {
            this.setCostSheetList(new ArrayList<CostSheet>());
        }
        this.getCostSheetList().add(item);
        item.setManufOrder(this);
    }

    public void removeCostSheetListItem(CostSheet item) {
        if (this.getCostSheetList() == null) {
            return;
        }
        this.getCostSheetList().remove(item);
    }

    public void clearCostSheetList() {
        if (this.getCostSheetList() != null) {
            this.getCostSheetList().clear();
        }
    }

    public BigDecimal getCostPrice() {
        return this.costPrice == null ? BigDecimal.ZERO : this.costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public ProdProcess getProdProcess() {
        return this.prodProcess;
    }

    public void setProdProcess(ProdProcess prodProcess) {
        this.prodProcess = prodProcess;
    }

    public LocalDateTime getPlannedStartDateT() {
        return this.plannedStartDateT;
    }

    public void setPlannedStartDateT(LocalDateTime plannedStartDateT) {
        this.plannedStartDateT = plannedStartDateT;
    }

    public LocalDateTime getPlannedEndDateT() {
        return this.plannedEndDateT;
    }

    public void setPlannedEndDateT(LocalDateTime plannedEndDateT) {
        this.plannedEndDateT = plannedEndDateT;
    }

    public StockLocation getWorkshopStockLocation() {
        return this.workshopStockLocation;
    }

    public void setWorkshopStockLocation(StockLocation workshopStockLocation) {
        this.workshopStockLocation = workshopStockLocation;
    }

    public LocalDateTime getRealStartDateT() {
        return this.realStartDateT;
    }

    public void setRealStartDateT(LocalDateTime realStartDateT) {
        this.realStartDateT = realStartDateT;
    }

    public LocalDateTime getRealEndDateT() {
        return this.realEndDateT;
    }

    public void setRealEndDateT(LocalDateTime realEndDateT) {
        this.realEndDateT = realEndDateT;
    }

    public BigDecimal getEndTimeDifference() {
        return this.endTimeDifference == null ? BigDecimal.ZERO : this.endTimeDifference;
    }

    public void setEndTimeDifference(BigDecimal endTimeDifference) {
        this.endTimeDifference = endTimeDifference;
    }

    public List<StockMove> getInStockMoveList() {
        return this.inStockMoveList;
    }

    public void setInStockMoveList(List<StockMove> inStockMoveList) {
        this.inStockMoveList = inStockMoveList;
    }

    public void addInStockMoveListItem(StockMove item) {
        if (this.getInStockMoveList() == null) {
            this.setInStockMoveList(new ArrayList<StockMove>());
        }
        this.getInStockMoveList().add(item);
        item.setInManufOrder(this);
    }

    public void removeInStockMoveListItem(StockMove item) {
        if (this.getInStockMoveList() == null) {
            return;
        }
        this.getInStockMoveList().remove((Object)item);
    }

    public void clearInStockMoveList() {
        if (this.getInStockMoveList() != null) {
            this.getInStockMoveList().clear();
        }
    }

    public List<StockMove> getOutStockMoveList() {
        return this.outStockMoveList;
    }

    public void setOutStockMoveList(List<StockMove> outStockMoveList) {
        this.outStockMoveList = outStockMoveList;
    }

    public void addOutStockMoveListItem(StockMove item) {
        if (this.getOutStockMoveList() == null) {
            this.setOutStockMoveList(new ArrayList<StockMove>());
        }
        this.getOutStockMoveList().add(item);
        item.setOutManufOrder(this);
    }

    public void removeOutStockMoveListItem(StockMove item) {
        if (this.getOutStockMoveList() == null) {
            return;
        }
        this.getOutStockMoveList().remove((Object)item);
    }

    public void clearOutStockMoveList() {
        if (this.getOutStockMoveList() != null) {
            this.getOutStockMoveList().clear();
        }
    }

    public StockMove getWasteStockMove() {
        return this.wasteStockMove;
    }

    public void setWasteStockMove(StockMove wasteStockMove) {
        this.wasteStockMove = wasteStockMove;
    }

    public String getWasteProdDescription() {
        return this.wasteProdDescription;
    }

    public void setWasteProdDescription(String wasteProdDescription) {
        this.wasteProdDescription = wasteProdDescription;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public CancelReason getCancelReason() {
        return this.cancelReason;
    }

    public void setCancelReason(CancelReason cancelReason) {
        this.cancelReason = cancelReason;
    }

    public String getCancelReasonStr() {
        return this.cancelReasonStr;
    }

    public void setCancelReasonStr(String cancelReasonStr) {
        this.cancelReasonStr = cancelReasonStr;
    }

    public String getMoCommentFromSaleOrder() {
        return this.moCommentFromSaleOrder;
    }

    public void setMoCommentFromSaleOrder(String moCommentFromSaleOrder) {
        this.moCommentFromSaleOrder = moCommentFromSaleOrder;
    }

    public Boolean getInvoiced() {
        return this.invoiced == null ? Boolean.FALSE : this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public Boolean getIsToInvoice() {
        return this.isToInvoice == null ? Boolean.FALSE : this.isToInvoice;
    }

    public void setIsToInvoice(Boolean isToInvoice) {
        this.isToInvoice = isToInvoice;
    }

    public List<TimesheetLine> getTimesheetLine() {
        return this.timesheetLine;
    }

    public void setTimesheetLine(List<TimesheetLine> timesheetLine) {
        this.timesheetLine = timesheetLine;
    }

    public void addTimesheetLine(TimesheetLine item) {
        if (this.getTimesheetLine() == null) {
            this.setTimesheetLine(new ArrayList<TimesheetLine>());
        }
        this.getTimesheetLine().add(item);
        item.setManufOrder(this);
    }

    public void removeTimesheetLine(TimesheetLine item) {
        if (this.getTimesheetLine() == null) {
            return;
        }
        this.getTimesheetLine().remove((Object)item);
    }

    public void clearTimesheetLine() {
        if (this.getTimesheetLine() != null) {
            this.getTimesheetLine().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ManufOrder)) {
            return false;
        }
        ManufOrder other = (ManufOrder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("qty", (Object)this.getQty()).add("manufOrderSeq", (Object)this.getManufOrderSeq()).add("prioritySelect", (Object)this.getPrioritySelect()).add("isPermanent", (Object)this.getIsPermanent()).add("isConsProOnOperation", (Object)this.getIsConsProOnOperation()).add("costPrice", (Object)this.getCostPrice()).add("plannedStartDateT", (Object)this.getPlannedStartDateT()).add("plannedEndDateT", (Object)this.getPlannedEndDateT()).add("realStartDateT", (Object)this.getRealStartDateT()).add("realEndDateT", (Object)this.getRealEndDateT()).add("endTimeDifference", (Object)this.getEndTimeDifference()).omitNullValues().toString();
    }
}

