/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.production.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.production.db.ManufOrder;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="PRODUCTION_PRODUCTION_ORDER", indexes={@Index(columnList="client_partner"), @Index(columnList="sale_order"), @Index(columnList="project")})
public class ProductionOrder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PRODUCTION_PRODUCTION_ORDER_SEQ")
    @SequenceGenerator(name="PRODUCTION_PRODUCTION_ORDER_SEQ", sequenceName="PRODUCTION_PRODUCTION_ORDER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Priority", selection="production.order.priority.select")
    private Integer prioritySelect = 2;
    @HashKey
    @Widget(title="Name")
    @NameColumn
    @NotNull
    @Column(unique=true)
    private String productionOrderSeq;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner clientPartner;
    @Widget(title="Sale order")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleOrder saleOrder;
    @Widget(title="Manufacturing orders")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="productionOrder", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="prioritySelect")
    private List<ManufOrder> manufOrderList;
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private Boolean isClosed = Boolean.FALSE;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProductionOrder() {
    }

    public ProductionOrder(String productionOrderSeq) {
        this.productionOrderSeq = productionOrderSeq;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPrioritySelect() {
        return this.prioritySelect == null ? 0 : this.prioritySelect;
    }

    public void setPrioritySelect(Integer prioritySelect) {
        this.prioritySelect = prioritySelect;
    }

    public String getProductionOrderSeq() {
        return this.productionOrderSeq;
    }

    public void setProductionOrderSeq(String productionOrderSeq) {
        this.productionOrderSeq = productionOrderSeq;
    }

    public Partner getClientPartner() {
        return this.clientPartner;
    }

    public void setClientPartner(Partner clientPartner) {
        this.clientPartner = clientPartner;
    }

    public SaleOrder getSaleOrder() {
        return this.saleOrder;
    }

    public void setSaleOrder(SaleOrder saleOrder) {
        this.saleOrder = saleOrder;
    }

    public List<ManufOrder> getManufOrderList() {
        return this.manufOrderList;
    }

    public void setManufOrderList(List<ManufOrder> manufOrderList) {
        this.manufOrderList = manufOrderList;
    }

    public void addManufOrderListItem(ManufOrder item) {
        if (this.getManufOrderList() == null) {
            this.setManufOrderList(new ArrayList<ManufOrder>());
        }
        this.getManufOrderList().add(item);
        item.setProductionOrder(this);
    }

    public void removeManufOrderListItem(ManufOrder item) {
        if (this.getManufOrderList() == null) {
            return;
        }
        this.getManufOrderList().remove((Object)item);
    }

    public void clearManufOrderList() {
        if (this.getManufOrderList() != null) {
            this.getManufOrderList().clear();
        }
    }

    public Boolean getIsClosed() {
        try {
            this.isClosed = this.computeIsClosed();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getIsClosed()", (Throwable)e);
        }
        return this.isClosed;
    }

    protected Boolean computeIsClosed() {
        if (this.manufOrderList == null || this.manufOrderList.isEmpty()) {
            return false;
        }
        for (ManufOrder mf : this.manufOrderList) {
            if (mf.getStatusSelect() == 2 || mf.getStatusSelect() == 6) continue;
            return false;
        }
        return true;
    }

    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProductionOrder)) {
            return false;
        }
        ProductionOrder other = (ProductionOrder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getProductionOrderSeq(), other.getProductionOrderSeq());
    }

    public int hashCode() {
        return Objects.hash(350939637, this.getProductionOrderSeq());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("prioritySelect", (Object)this.getPrioritySelect()).add("productionOrderSeq", (Object)this.getProductionOrderSeq()).omitNullValues().toString();
    }
}

