/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.people.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.people.v1.PeopleServiceRequest;
import com.google.api.services.people.v1.PeopleServiceRequestInitializer;
import com.google.api.services.people.v1.model.BatchGetContactGroupsResponse;
import com.google.api.services.people.v1.model.ContactGroup;
import com.google.api.services.people.v1.model.CreateContactGroupRequest;
import com.google.api.services.people.v1.model.DeleteContactPhotoResponse;
import com.google.api.services.people.v1.model.Empty;
import com.google.api.services.people.v1.model.GetPeopleResponse;
import com.google.api.services.people.v1.model.ListConnectionsResponse;
import com.google.api.services.people.v1.model.ListContactGroupsResponse;
import com.google.api.services.people.v1.model.ModifyContactGroupMembersRequest;
import com.google.api.services.people.v1.model.ModifyContactGroupMembersResponse;
import com.google.api.services.people.v1.model.Person;
import com.google.api.services.people.v1.model.UpdateContactGroupRequest;
import com.google.api.services.people.v1.model.UpdateContactPhotoRequest;
import com.google.api.services.people.v1.model.UpdateContactPhotoResponse;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeopleService
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://people.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://people.googleapis.com/";

    public PeopleService(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    PeopleService(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public ContactGroups contactGroups() {
        return new ContactGroups();
    }

    public People people() {
        return new People();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the People API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://people.googleapis.com/", PeopleService.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(PeopleService.DEFAULT_BATCH_PATH);
        }

        public PeopleService build() {
            return new PeopleService(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setPeopleServiceRequestInitializer(PeopleServiceRequestInitializer peopleServiceRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)peopleServiceRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class People {
        public CreateContact createContact(Person person) throws IOException {
            CreateContact createContact = new CreateContact(person);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)createContact);
            return createContact;
        }

        public DeleteContact deleteContact(String string) throws IOException {
            DeleteContact deleteContact = new DeleteContact(string);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)deleteContact);
            return deleteContact;
        }

        public DeleteContactPhoto deleteContactPhoto(String string) throws IOException {
            DeleteContactPhoto deleteContactPhoto = new DeleteContactPhoto(string);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)deleteContactPhoto);
            return deleteContactPhoto;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetBatchGet getBatchGet() throws IOException {
            GetBatchGet getBatchGet = new GetBatchGet();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)getBatchGet);
            return getBatchGet;
        }

        public UpdateContact updateContact(String string, Person person) throws IOException {
            UpdateContact updateContact = new UpdateContact(string, person);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)updateContact);
            return updateContact;
        }

        public UpdateContactPhoto updateContactPhoto(String string, UpdateContactPhotoRequest updateContactPhotoRequest) throws IOException {
            UpdateContactPhoto updateContactPhoto = new UpdateContactPhoto(string, updateContactPhotoRequest);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)updateContactPhoto);
            return updateContactPhoto;
        }

        public Connections connections() {
            return new Connections();
        }

        public class Connections {
            public List list(String string) throws IOException {
                List list = new List(string);
                PeopleService.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends PeopleServiceRequest<ListConnectionsResponse> {
                private static final String REST_PATH = "v1/{+resourceName}/connections";
                private final Pattern RESOURCE_NAME_PATTERN;
                @Key
                private String resourceName;
                @Key
                private String personFields;
                @Key
                private String sortOrder;
                @Key
                private Boolean requestSyncToken;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key(value="requestMask.includeField")
                private String requestMaskIncludeField;
                @Key
                private String syncToken;

                protected List(String string) {
                    super(PeopleService.this, "GET", REST_PATH, null, ListConnectionsResponse.class);
                    this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                    this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getResourceName() {
                    return this.resourceName;
                }

                public List setResourceName(String string) {
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                    }
                    this.resourceName = string;
                    return this;
                }

                public String getPersonFields() {
                    return this.personFields;
                }

                public List setPersonFields(String string) {
                    this.personFields = string;
                    return this;
                }

                public String getSortOrder() {
                    return this.sortOrder;
                }

                public List setSortOrder(String string) {
                    this.sortOrder = string;
                    return this;
                }

                public Boolean getRequestSyncToken() {
                    return this.requestSyncToken;
                }

                public List setRequestSyncToken(Boolean bl) {
                    this.requestSyncToken = bl;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getRequestMaskIncludeField() {
                    return this.requestMaskIncludeField;
                }

                public List setRequestMaskIncludeField(String string) {
                    this.requestMaskIncludeField = string;
                    return this;
                }

                public String getSyncToken() {
                    return this.syncToken;
                }

                public List setSyncToken(String string) {
                    this.syncToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class UpdateContactPhoto
        extends PeopleServiceRequest<UpdateContactPhotoResponse> {
            private static final String REST_PATH = "v1/{+resourceName}:updateContactPhoto";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected UpdateContactPhoto(String string, UpdateContactPhotoRequest updateContactPhotoRequest) {
                super(PeopleService.this, "PATCH", REST_PATH, (Object)updateContactPhotoRequest, UpdateContactPhotoResponse.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public UpdateContactPhoto set$Xgafv(String string) {
                return (UpdateContactPhoto)super.set$Xgafv(string);
            }

            public UpdateContactPhoto setAccessToken(String string) {
                return (UpdateContactPhoto)super.setAccessToken(string);
            }

            public UpdateContactPhoto setAlt(String string) {
                return (UpdateContactPhoto)super.setAlt(string);
            }

            public UpdateContactPhoto setCallback(String string) {
                return (UpdateContactPhoto)super.setCallback(string);
            }

            public UpdateContactPhoto setFields(String string) {
                return (UpdateContactPhoto)super.setFields(string);
            }

            public UpdateContactPhoto setKey(String string) {
                return (UpdateContactPhoto)super.setKey(string);
            }

            public UpdateContactPhoto setOauthToken(String string) {
                return (UpdateContactPhoto)super.setOauthToken(string);
            }

            public UpdateContactPhoto setPrettyPrint(Boolean bl) {
                return (UpdateContactPhoto)super.setPrettyPrint(bl);
            }

            public UpdateContactPhoto setQuotaUser(String string) {
                return (UpdateContactPhoto)super.setQuotaUser(string);
            }

            public UpdateContactPhoto setUploadType(String string) {
                return (UpdateContactPhoto)super.setUploadType(string);
            }

            public UpdateContactPhoto setUploadProtocol(String string) {
                return (UpdateContactPhoto)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public UpdateContactPhoto setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            @Override
            public UpdateContactPhoto set(String string, Object object) {
                return (UpdateContactPhoto)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class UpdateContact
        extends PeopleServiceRequest<Person> {
            private static final String REST_PATH = "v1/{+resourceName}:updateContact";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private String updatePersonFields;

            protected UpdateContact(String string, Person person) {
                super(PeopleService.this, "PATCH", REST_PATH, (Object)person, Person.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public UpdateContact set$Xgafv(String string) {
                return (UpdateContact)super.set$Xgafv(string);
            }

            public UpdateContact setAccessToken(String string) {
                return (UpdateContact)super.setAccessToken(string);
            }

            public UpdateContact setAlt(String string) {
                return (UpdateContact)super.setAlt(string);
            }

            public UpdateContact setCallback(String string) {
                return (UpdateContact)super.setCallback(string);
            }

            public UpdateContact setFields(String string) {
                return (UpdateContact)super.setFields(string);
            }

            public UpdateContact setKey(String string) {
                return (UpdateContact)super.setKey(string);
            }

            public UpdateContact setOauthToken(String string) {
                return (UpdateContact)super.setOauthToken(string);
            }

            public UpdateContact setPrettyPrint(Boolean bl) {
                return (UpdateContact)super.setPrettyPrint(bl);
            }

            public UpdateContact setQuotaUser(String string) {
                return (UpdateContact)super.setQuotaUser(string);
            }

            public UpdateContact setUploadType(String string) {
                return (UpdateContact)super.setUploadType(string);
            }

            public UpdateContact setUploadProtocol(String string) {
                return (UpdateContact)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public UpdateContact setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            public String getUpdatePersonFields() {
                return this.updatePersonFields;
            }

            public UpdateContact setUpdatePersonFields(String string) {
                this.updatePersonFields = string;
                return this;
            }

            @Override
            public UpdateContact set(String string, Object object) {
                return (UpdateContact)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetBatchGet
        extends PeopleServiceRequest<GetPeopleResponse> {
            private static final String REST_PATH = "v1/people:batchGet";
            @Key
            private List<String> resourceNames;
            @Key
            private String personFields;
            @Key(value="requestMask.includeField")
            private String requestMaskIncludeField;

            protected GetBatchGet() {
                super(PeopleService.this, "GET", REST_PATH, null, GetPeopleResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetBatchGet set$Xgafv(String string) {
                return (GetBatchGet)super.set$Xgafv(string);
            }

            public GetBatchGet setAccessToken(String string) {
                return (GetBatchGet)super.setAccessToken(string);
            }

            public GetBatchGet setAlt(String string) {
                return (GetBatchGet)super.setAlt(string);
            }

            public GetBatchGet setCallback(String string) {
                return (GetBatchGet)super.setCallback(string);
            }

            public GetBatchGet setFields(String string) {
                return (GetBatchGet)super.setFields(string);
            }

            public GetBatchGet setKey(String string) {
                return (GetBatchGet)super.setKey(string);
            }

            public GetBatchGet setOauthToken(String string) {
                return (GetBatchGet)super.setOauthToken(string);
            }

            public GetBatchGet setPrettyPrint(Boolean bl) {
                return (GetBatchGet)super.setPrettyPrint(bl);
            }

            public GetBatchGet setQuotaUser(String string) {
                return (GetBatchGet)super.setQuotaUser(string);
            }

            public GetBatchGet setUploadType(String string) {
                return (GetBatchGet)super.setUploadType(string);
            }

            public GetBatchGet setUploadProtocol(String string) {
                return (GetBatchGet)super.setUploadProtocol(string);
            }

            public List<String> getResourceNames() {
                return this.resourceNames;
            }

            public GetBatchGet setResourceNames(List<String> list) {
                this.resourceNames = list;
                return this;
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public GetBatchGet setPersonFields(String string) {
                this.personFields = string;
                return this;
            }

            public String getRequestMaskIncludeField() {
                return this.requestMaskIncludeField;
            }

            public GetBatchGet setRequestMaskIncludeField(String string) {
                this.requestMaskIncludeField = string;
                return this;
            }

            @Override
            public GetBatchGet set(String string, Object object) {
                return (GetBatchGet)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PeopleServiceRequest<Person> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private String personFields;
            @Key(value="requestMask.includeField")
            private String requestMaskIncludeField;

            protected Get(String string) {
                super(PeopleService.this, "GET", REST_PATH, null, Person.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Get setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public Get setPersonFields(String string) {
                this.personFields = string;
                return this;
            }

            public String getRequestMaskIncludeField() {
                return this.requestMaskIncludeField;
            }

            public Get setRequestMaskIncludeField(String string) {
                this.requestMaskIncludeField = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteContactPhoto
        extends PeopleServiceRequest<DeleteContactPhotoResponse> {
            private static final String REST_PATH = "v1/{+resourceName}:deleteContactPhoto";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private String personFields;

            protected DeleteContactPhoto(String string) {
                super(PeopleService.this, "DELETE", REST_PATH, null, DeleteContactPhotoResponse.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public DeleteContactPhoto set$Xgafv(String string) {
                return (DeleteContactPhoto)super.set$Xgafv(string);
            }

            public DeleteContactPhoto setAccessToken(String string) {
                return (DeleteContactPhoto)super.setAccessToken(string);
            }

            public DeleteContactPhoto setAlt(String string) {
                return (DeleteContactPhoto)super.setAlt(string);
            }

            public DeleteContactPhoto setCallback(String string) {
                return (DeleteContactPhoto)super.setCallback(string);
            }

            public DeleteContactPhoto setFields(String string) {
                return (DeleteContactPhoto)super.setFields(string);
            }

            public DeleteContactPhoto setKey(String string) {
                return (DeleteContactPhoto)super.setKey(string);
            }

            public DeleteContactPhoto setOauthToken(String string) {
                return (DeleteContactPhoto)super.setOauthToken(string);
            }

            public DeleteContactPhoto setPrettyPrint(Boolean bl) {
                return (DeleteContactPhoto)super.setPrettyPrint(bl);
            }

            public DeleteContactPhoto setQuotaUser(String string) {
                return (DeleteContactPhoto)super.setQuotaUser(string);
            }

            public DeleteContactPhoto setUploadType(String string) {
                return (DeleteContactPhoto)super.setUploadType(string);
            }

            public DeleteContactPhoto setUploadProtocol(String string) {
                return (DeleteContactPhoto)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public DeleteContactPhoto setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            public String getPersonFields() {
                return this.personFields;
            }

            public DeleteContactPhoto setPersonFields(String string) {
                this.personFields = string;
                return this;
            }

            @Override
            public DeleteContactPhoto set(String string, Object object) {
                return (DeleteContactPhoto)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteContact
        extends PeopleServiceRequest<Empty> {
            private static final String REST_PATH = "v1/{+resourceName}:deleteContact";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected DeleteContact(String string) {
                super(PeopleService.this, "DELETE", REST_PATH, null, Empty.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^people/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
            }

            public DeleteContact set$Xgafv(String string) {
                return (DeleteContact)super.set$Xgafv(string);
            }

            public DeleteContact setAccessToken(String string) {
                return (DeleteContact)super.setAccessToken(string);
            }

            public DeleteContact setAlt(String string) {
                return (DeleteContact)super.setAlt(string);
            }

            public DeleteContact setCallback(String string) {
                return (DeleteContact)super.setCallback(string);
            }

            public DeleteContact setFields(String string) {
                return (DeleteContact)super.setFields(string);
            }

            public DeleteContact setKey(String string) {
                return (DeleteContact)super.setKey(string);
            }

            public DeleteContact setOauthToken(String string) {
                return (DeleteContact)super.setOauthToken(string);
            }

            public DeleteContact setPrettyPrint(Boolean bl) {
                return (DeleteContact)super.setPrettyPrint(bl);
            }

            public DeleteContact setQuotaUser(String string) {
                return (DeleteContact)super.setQuotaUser(string);
            }

            public DeleteContact setUploadType(String string) {
                return (DeleteContact)super.setUploadType(string);
            }

            public DeleteContact setUploadProtocol(String string) {
                return (DeleteContact)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public DeleteContact setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^people/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            @Override
            public DeleteContact set(String string, Object object) {
                return (DeleteContact)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class CreateContact
        extends PeopleServiceRequest<Person> {
            private static final String REST_PATH = "v1/people:createContact";

            protected CreateContact(Person person) {
                super(PeopleService.this, "POST", REST_PATH, (Object)person, Person.class);
            }

            public CreateContact set$Xgafv(String string) {
                return (CreateContact)super.set$Xgafv(string);
            }

            public CreateContact setAccessToken(String string) {
                return (CreateContact)super.setAccessToken(string);
            }

            public CreateContact setAlt(String string) {
                return (CreateContact)super.setAlt(string);
            }

            public CreateContact setCallback(String string) {
                return (CreateContact)super.setCallback(string);
            }

            public CreateContact setFields(String string) {
                return (CreateContact)super.setFields(string);
            }

            public CreateContact setKey(String string) {
                return (CreateContact)super.setKey(string);
            }

            public CreateContact setOauthToken(String string) {
                return (CreateContact)super.setOauthToken(string);
            }

            public CreateContact setPrettyPrint(Boolean bl) {
                return (CreateContact)super.setPrettyPrint(bl);
            }

            public CreateContact setQuotaUser(String string) {
                return (CreateContact)super.setQuotaUser(string);
            }

            public CreateContact setUploadType(String string) {
                return (CreateContact)super.setUploadType(string);
            }

            public CreateContact setUploadProtocol(String string) {
                return (CreateContact)super.setUploadProtocol(string);
            }

            @Override
            public CreateContact set(String string, Object object) {
                return (CreateContact)super.set(string, object);
            }
        }
    }

    public class ContactGroups {
        public BatchGet batchGet() throws IOException {
            BatchGet batchGet = new BatchGet();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)batchGet);
            return batchGet;
        }

        public Create create(CreateContactGroupRequest createContactGroupRequest) throws IOException {
            Create create = new Create(createContactGroupRequest);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Update update(String string, UpdateContactGroupRequest updateContactGroupRequest) throws IOException {
            Update update = new Update(string, updateContactGroupRequest);
            PeopleService.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Members members() {
            return new Members();
        }

        public class Members {
            public Modify modify(String string, ModifyContactGroupMembersRequest modifyContactGroupMembersRequest) throws IOException {
                Modify modify = new Modify(string, modifyContactGroupMembersRequest);
                PeopleService.this.initialize((AbstractGoogleClientRequest<?>)modify);
                return modify;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Modify
            extends PeopleServiceRequest<ModifyContactGroupMembersResponse> {
                private static final String REST_PATH = "v1/{+resourceName}/members:modify";
                private final Pattern RESOURCE_NAME_PATTERN;
                @Key
                private String resourceName;

                protected Modify(String string, ModifyContactGroupMembersRequest modifyContactGroupMembersRequest) {
                    super(PeopleService.this, "POST", REST_PATH, (Object)modifyContactGroupMembersRequest, ModifyContactGroupMembersResponse.class);
                    this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                    this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                    }
                }

                public Modify set$Xgafv(String string) {
                    return (Modify)super.set$Xgafv(string);
                }

                public Modify setAccessToken(String string) {
                    return (Modify)super.setAccessToken(string);
                }

                public Modify setAlt(String string) {
                    return (Modify)super.setAlt(string);
                }

                public Modify setCallback(String string) {
                    return (Modify)super.setCallback(string);
                }

                public Modify setFields(String string) {
                    return (Modify)super.setFields(string);
                }

                public Modify setKey(String string) {
                    return (Modify)super.setKey(string);
                }

                public Modify setOauthToken(String string) {
                    return (Modify)super.setOauthToken(string);
                }

                public Modify setPrettyPrint(Boolean bl) {
                    return (Modify)super.setPrettyPrint(bl);
                }

                public Modify setQuotaUser(String string) {
                    return (Modify)super.setQuotaUser(string);
                }

                public Modify setUploadType(String string) {
                    return (Modify)super.setUploadType(string);
                }

                public Modify setUploadProtocol(String string) {
                    return (Modify)super.setUploadProtocol(string);
                }

                public String getResourceName() {
                    return this.resourceName;
                }

                public Modify setResourceName(String string) {
                    if (!PeopleService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                    }
                    this.resourceName = string;
                    return this;
                }

                @Override
                public Modify set(String string, Object object) {
                    return (Modify)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends PeopleServiceRequest<ContactGroup> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Update(String string, UpdateContactGroupRequest updateContactGroupRequest) {
                super(PeopleService.this, "PUT", REST_PATH, (Object)updateContactGroupRequest, ContactGroup.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
            }

            public Update set$Xgafv(String string) {
                return (Update)super.set$Xgafv(string);
            }

            public Update setAccessToken(String string) {
                return (Update)super.setAccessToken(string);
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setCallback(String string) {
                return (Update)super.setCallback(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUploadType(String string) {
                return (Update)super.setUploadType(string);
            }

            public Update setUploadProtocol(String string) {
                return (Update)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Update setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends PeopleServiceRequest<ListContactGroupsResponse> {
            private static final String REST_PATH = "v1/contactGroups";
            @Key
            private String syncToken;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(PeopleService.this, "GET", REST_PATH, null, ListContactGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getSyncToken() {
                return this.syncToken;
            }

            public List setSyncToken(String string) {
                this.syncToken = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends PeopleServiceRequest<ContactGroup> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private Integer maxMembers;

            protected Get(String string) {
                super(PeopleService.this, "GET", REST_PATH, null, ContactGroup.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Get setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            public Integer getMaxMembers() {
                return this.maxMembers;
            }

            public Get setMaxMembers(Integer n) {
                this.maxMembers = n;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends PeopleServiceRequest<Empty> {
            private static final String REST_PATH = "v1/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;
            @Key
            private Boolean deleteContacts;

            protected Delete(String string) {
                super(PeopleService.this, "DELETE", REST_PATH, null, Empty.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^contactGroups/[^/]+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Delete setResourceName(String string) {
                if (!PeopleService.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^contactGroups/[^/]+$");
                }
                this.resourceName = string;
                return this;
            }

            public Boolean getDeleteContacts() {
                return this.deleteContacts;
            }

            public Delete setDeleteContacts(Boolean bl) {
                this.deleteContacts = bl;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends PeopleServiceRequest<ContactGroup> {
            private static final String REST_PATH = "v1/contactGroups";

            protected Create(CreateContactGroupRequest createContactGroupRequest) {
                super(PeopleService.this, "POST", REST_PATH, (Object)createContactGroupRequest, ContactGroup.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class BatchGet
        extends PeopleServiceRequest<BatchGetContactGroupsResponse> {
            private static final String REST_PATH = "v1/contactGroups:batchGet";
            @Key
            private Integer maxMembers;
            @Key
            private java.util.List<String> resourceNames;

            protected BatchGet() {
                super(PeopleService.this, "GET", REST_PATH, null, BatchGetContactGroupsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BatchGet set$Xgafv(String string) {
                return (BatchGet)super.set$Xgafv(string);
            }

            public BatchGet setAccessToken(String string) {
                return (BatchGet)super.setAccessToken(string);
            }

            public BatchGet setAlt(String string) {
                return (BatchGet)super.setAlt(string);
            }

            public BatchGet setCallback(String string) {
                return (BatchGet)super.setCallback(string);
            }

            public BatchGet setFields(String string) {
                return (BatchGet)super.setFields(string);
            }

            public BatchGet setKey(String string) {
                return (BatchGet)super.setKey(string);
            }

            public BatchGet setOauthToken(String string) {
                return (BatchGet)super.setOauthToken(string);
            }

            public BatchGet setPrettyPrint(Boolean bl) {
                return (BatchGet)super.setPrettyPrint(bl);
            }

            public BatchGet setQuotaUser(String string) {
                return (BatchGet)super.setQuotaUser(string);
            }

            public BatchGet setUploadType(String string) {
                return (BatchGet)super.setUploadType(string);
            }

            public BatchGet setUploadProtocol(String string) {
                return (BatchGet)super.setUploadProtocol(string);
            }

            public Integer getMaxMembers() {
                return this.maxMembers;
            }

            public BatchGet setMaxMembers(Integer n) {
                this.maxMembers = n;
                return this;
            }

            public java.util.List<String> getResourceNames() {
                return this.resourceNames;
            }

            public BatchGet setResourceNames(java.util.List<String> list) {
                this.resourceNames = list;
                return this;
            }

            @Override
            public BatchGet set(String string, Object object) {
                return (BatchGet)super.set(string, object);
            }
        }
    }
}

