/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.guava.deser.util.RangeFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.io.IOException;
import java.util.Arrays;

public class RangeDeserializer
extends StdDeserializer<Range<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _rangeType;
    protected final JsonDeserializer<Object> _endpointDeserializer;
    private BoundType _defaultBoundType;

    @Deprecated
    public RangeDeserializer(JavaType rangeType) {
        this(null, rangeType);
    }

    public RangeDeserializer(BoundType defaultBoundType, JavaType rangeType) {
        this(rangeType, null);
        this._defaultBoundType = defaultBoundType;
    }

    public RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser) {
        super(rangeType);
        this._rangeType = rangeType;
        this._endpointDeserializer = endpointDeser;
    }

    public RangeDeserializer(JavaType rangeType, JsonDeserializer<?> endpointDeser, BoundType defaultBoundType) {
        super(rangeType);
        this._rangeType = rangeType;
        this._endpointDeserializer = endpointDeser;
        this._defaultBoundType = defaultBoundType;
    }

    public JavaType getValueType() {
        return this._rangeType;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        if (this._endpointDeserializer == null) {
            JavaType endpointType = this._rangeType.containedType(0);
            if (endpointType == null) {
                endpointType = TypeFactory.unknownType();
            }
            JsonDeserializer deser = ctxt.findContextualValueDeserializer(endpointType, property);
            return new RangeDeserializer(this._rangeType, deser, this._defaultBoundType);
        }
        return this;
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    public Range<?> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = parser.nextToken();
        }
        Comparable<?> lowerEndpoint = null;
        Comparable<?> upperEndpoint = null;
        BoundType lowerBoundType = this._defaultBoundType;
        BoundType upperBoundType = this._defaultBoundType;
        while (t != JsonToken.END_OBJECT) {
            block13: {
                this.expect(context, JsonToken.FIELD_NAME, t);
                String fieldName = parser.getCurrentName();
                try {
                    if (fieldName.equals("lowerEndpoint")) {
                        parser.nextToken();
                        lowerEndpoint = this.deserializeEndpoint(context, parser);
                        break block13;
                    }
                    if (fieldName.equals("upperEndpoint")) {
                        parser.nextToken();
                        upperEndpoint = this.deserializeEndpoint(context, parser);
                        break block13;
                    }
                    if (fieldName.equals("lowerBoundType")) {
                        parser.nextToken();
                        lowerBoundType = this.deserializeBoundType(context, parser);
                        break block13;
                    }
                    if (fieldName.equals("upperBoundType")) {
                        parser.nextToken();
                        upperBoundType = this.deserializeBoundType(context, parser);
                        break block13;
                    }
                    throw context.mappingException("Unexpected Range field: " + fieldName);
                }
                catch (IllegalStateException e) {
                    throw JsonMappingException.from((JsonParser)parser, (String)e.getMessage());
                }
            }
            t = parser.nextToken();
        }
        try {
            if (lowerEndpoint != null && upperEndpoint != null) {
                Preconditions.checkState((lowerEndpoint.getClass() == upperEndpoint.getClass() ? 1 : 0) != 0, (String)"Endpoint types are not the same - 'lowerEndpoint' deserialized to [%s], and 'upperEndpoint' deserialized to [%s].", (Object[])new Object[]{lowerEndpoint.getClass().getName(), upperEndpoint.getClass().getName()});
                Preconditions.checkState((lowerBoundType != null ? 1 : 0) != 0, (Object)"'lowerEndpoint' field found, but not 'lowerBoundType'");
                Preconditions.checkState((upperBoundType != null ? 1 : 0) != 0, (Object)"'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.range(lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType);
            }
            if (lowerEndpoint != null) {
                Preconditions.checkState((lowerBoundType != null ? 1 : 0) != 0, (Object)"'lowerEndpoint' field found, but not 'lowerBoundType'");
                return RangeFactory.downTo(lowerEndpoint, lowerBoundType);
            }
            if (upperEndpoint != null) {
                Preconditions.checkState((upperBoundType != null ? 1 : 0) != 0, (Object)"'upperEndpoint' field found, but not 'upperBoundType'");
                return RangeFactory.upTo(upperEndpoint, upperBoundType);
            }
            return RangeFactory.all();
        }
        catch (IllegalStateException e) {
            throw JsonMappingException.from((JsonParser)parser, (String)e.getMessage());
        }
    }

    private BoundType deserializeBoundType(DeserializationContext context, JsonParser p) throws IOException {
        this.expect(context, JsonToken.VALUE_STRING, p.getCurrentToken());
        String name = p.getText();
        try {
            return BoundType.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            context.handleWeirdStringValue(BoundType.class, name, "not a valid BoundType name (should be one oF: %s)", new Object[]{Arrays.asList(BoundType.values())});
            return null;
        }
    }

    private Comparable<?> deserializeEndpoint(DeserializationContext context, JsonParser parser) throws IOException {
        Object obj = this._endpointDeserializer.deserialize(parser, context);
        if (!(obj instanceof Comparable)) {
            throw context.mappingException(String.format("Field [%s] deserialized to [%s], which does not implement Comparable.", parser.getCurrentName(), obj.getClass().getName()));
        }
        return (Comparable)obj;
    }

    private void expect(DeserializationContext context, JsonToken expected, JsonToken actual) throws JsonMappingException {
        if (actual != expected) {
            context.reportWrongTokenException(context.getParser(), expected, null, new Object[0]);
        }
    }
}

