/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.app.internal;

import com.axelor.app.internal.AppLogger;
import com.axelor.tomcat.TomcatRunner;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppRunner {
    private static Logger log = LoggerFactory.getLogger(AppRunner.class);

    public static void main(String[] args) {
        AppLogger.install();
        try {
            AppRunner.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            AppLogger.uninstall();
        }
    }

    private static boolean prepare() {
        Path configFile = Paths.get("build", "tomcat", "axelor-tomcat.properties");
        Path webapp = Paths.get("build", "webapp");
        if (Files.exists(configFile, new LinkOption[0]) && Files.exists(webapp, new LinkOption[0])) {
            return true;
        }
        log.info("Preparing...");
        Path gradlew = Paths.get(File.separatorChar == '\\' ? "gradlew.bat" : "gradlew", new String[0]).normalize().toAbsolutePath();
        ProcessBuilder builder = new ProcessBuilder(gradlew.toString(), "runnerConfig");
        try {
            Process process = builder.start();
            if (process.waitFor() != 0 || Files.notExists(configFile, new LinkOption[0]) && Files.notExists(configFile, new LinkOption[0])) {
                log.error("Please run './gradlew runnerConfig' and try again.");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void run(String[] args) {
        if (AppRunner.prepare()) {
            log.info("Starting...");
            TomcatRunner.main((String[])args);
        }
    }
}

