/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.AuthRealm;
import com.axelor.auth.AuthUtils;
import com.axelor.common.StringUtils;
import com.axelor.event.Event;
import com.axelor.event.NamedLiteral;
import com.axelor.events.LoginRedirectException;
import com.axelor.events.PostLogin;
import com.axelor.events.PreLogin;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

public class AuthFilter
extends FormAuthenticationFilter {
    @Inject
    private Event<PreLogin> preLogin;
    @Inject
    private Event<PostLogin> postLogin;

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        AuthenticationToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
            throw new IllegalStateException(msg);
        }
        try {
            try {
                this.preLogin.fire(new PreLogin(token));
                Subject subject = this.getSubject(request, response);
                subject.login(token);
                this.postLogin.select(new Annotation[]{NamedLiteral.of("success")}).fire(new PostLogin(token, AuthUtils.getUser(), null));
                return this.onLoginSuccess(token, subject, request, response);
            }
            catch (AuthenticationException e) {
                this.postLogin.select(new Annotation[]{NamedLiteral.of("failure")}).fire(new PostLogin(token, null, e));
                return this.onLoginFailure(token, e, request, response);
            }
        }
        catch (LoginRedirectException e) {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)e.getLocation());
            return false;
        }
    }

    protected AuthenticationToken createToken(String username, String password, ServletRequest request, ServletResponse response) {
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        return new UsernamePasswordTokenWithParams(username, password, rememberMe, host, request);
    }

    private boolean isRootWithoutSlash(ServletRequest request) {
        HttpServletRequest req = (HttpServletRequest)request;
        String ctx = WebUtils.getContextPath((HttpServletRequest)req);
        String uri = WebUtils.getRequestUri((HttpServletRequest)req);
        return ctx != null && uri != null && !uri.endsWith("/") && ctx.length() == uri.length();
    }

    protected boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        return super.isLoginRequest(request, response) || this.pathsMatch("/callback", request);
    }

    public void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        AuthFilter.setSameSiteNone((HttpServletRequest)request, (HttpServletResponse)response);
        if (!SecurityUtils.getSubject().isAuthenticated() && this.isRootWithoutSlash(request)) {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)"/");
            return;
        }
        if (this.isLoginRequest(request, response) && SecurityUtils.getSubject().isAuthenticated()) {
            if (this.isXHR(request) && this.isLoginSubmission(request, response)) {
                WebUtils.toHttp((ServletResponse)response).setStatus(200);
                return;
            }
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)"/");
        }
        super.doFilterInternal(request, response, chain);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        request.setCharacterEncoding("UTF-8");
        if (this.isXHR(request)) {
            int status = 401;
            if (this.isLoginRequest(request, response) && this.isLoginSubmission(request, response) && this.doLogin(request, response)) {
                status = 200;
            }
            ((HttpServletResponse)response).setStatus(status);
            return false;
        }
        return super.onAccessDenied(request, response);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        AuthFilter.changeSessionId((HttpServletRequest)request, (HttpServletResponse)response);
        return super.onLoginSuccess(token, subject, request, response);
    }

    private static void changeSessionId(HttpServletRequest request, HttpServletResponse response) {
        request.changeSessionId();
        AuthFilter.setSameSiteNone(request, response);
    }

    public static void setSameSiteNone(HttpServletRequest request, HttpServletResponse response) {
        Subject subject = SecurityUtils.getSubject();
        subject.getSession();
        if (!request.isSecure() && !"https".equalsIgnoreCase(AuthFilter.getProto(request))) {
            return;
        }
        Collection headers = response.getHeaders("Set-Cookie");
        Iterator it = headers.iterator();
        if (it.hasNext()) {
            AuthFilter.addSameSiteCookieHeader((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)it.next());
            while (it.hasNext()) {
                AuthFilter.addSameSiteCookieHeader((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1), (String)it.next());
            }
        }
    }

    private static String getProto(HttpServletRequest request) {
        String proto = request.getHeader("X-Forwarded-Proto");
        return StringUtils.isBlank((CharSequence)proto) ? request.getScheme() : proto;
    }

    private static void addSameSiteCookieHeader(BiConsumer<String, String> adder, String header) {
        String extraAttrs = "; SameSite=None";
        if (header.indexOf("; Secure") < 0) {
            extraAttrs = extraAttrs + "; Secure";
        }
        adder.accept("Set-Cookie", header + extraAttrs);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        if (e instanceof IncorrectCredentialsException) {
            UriBuilder builder = UriBuilder.fromPath((String)"login.jsp");
            if (StringUtils.notBlank((CharSequence)e.getMessage())) {
                builder.queryParam("error", new Object[]{e.getMessage()});
            }
            String path = builder.build(new Object[0]).toString();
            this.forward(path, request, response);
        } else if (e instanceof AuthRealm.UserExpiredCredentialsException) {
            String username = ((AuthRealm.UserExpiredCredentialsException)((Object)e)).getUser().getCode();
            UriBuilder builder = UriBuilder.fromPath((String)"change-password.jsp").queryParam("username", new Object[]{username});
            if (StringUtils.notBlank((CharSequence)e.getMessage())) {
                builder.queryParam("error", new Object[]{e.getMessage()});
            }
            String path = builder.build(new Object[0]).toString();
            this.forward(path, request, response);
        }
        return super.onLoginFailure(token, e, request, response);
    }

    private void forward(String path, ServletRequest request, ServletResponse response) {
        try {
            ((HttpServletRequest)request).getRequestDispatcher(path).forward(request, response);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean doLogin(ServletRequest request, ServletResponse response) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map data = (Map)mapper.readValue((InputStream)request.getInputStream(), Map.class);
        String username = (String)data.get("username");
        String password = (String)data.get("password");
        AuthenticationToken token = this.createToken(username, password, request, response);
        Subject subject = this.getSubject(request, response);
        try {
            this.preLogin.fire(new PreLogin(token));
            subject.login(token);
            this.postLogin.select(new Annotation[]{NamedLiteral.of("success")}).fire(new PostLogin(token, AuthUtils.getUser(), null));
        }
        catch (AuthenticationException e) {
            this.postLogin.select(new Annotation[]{NamedLiteral.of("failure")}).fire(new PostLogin(token, null, e));
            return false;
        }
        return true;
    }

    private boolean isXHR(ServletRequest request) {
        HttpServletRequest req = (HttpServletRequest)request;
        return "XMLHttpRequest".equals(req.getHeader("X-Requested-With")) || "application/json".equals(req.getHeader("Accept")) || "application/json".equals(req.getHeader("Content-Type"));
    }

    static class UsernamePasswordTokenWithParams
    extends UsernamePasswordToken {
        private static final long serialVersionUID = -1003682418365507707L;
        private final transient ServletRequest request;

        public UsernamePasswordTokenWithParams(String username, String password, boolean rememberMe, String host, ServletRequest request) {
            super(username, password, rememberMe, host);
            this.request = request;
        }

        public String getCleanParam(String paramName) {
            return WebUtils.getCleanParam((ServletRequest)this.request, (String)paramName);
        }
    }
}

