/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.AuthSessionService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.event.Observes;
import com.axelor.events.PostLogin;
import com.axelor.events.PreRequest;
import com.axelor.i18n.I18n;
import com.google.inject.Singleton;
import java.time.LocalDateTime;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.subject.Subject;

@Singleton
public class AuthObserver {
    @Inject
    private AuthSessionService authSessionService;

    void onPostLogin(@Observes @Named(value="success") PostLogin event) {
        this.authSessionService.updateLoginDate();
    }

    void onPreRequest(@Observes PreRequest event) {
        Subject subject = AuthUtils.getSubject();
        if (subject != null) {
            User user = AuthUtils.getUser();
            LocalDateTime loginDate = this.authSessionService.getLoginDate(subject.getSession());
            if (user != null && AuthUtils.isActive(user) && (user.getPasswordUpdatedOn() == null || loginDate != null && !loginDate.isBefore(user.getPasswordUpdatedOn()))) {
                return;
            }
            subject.logout();
        }
        throw new UnauthenticatedException(I18n.get("Please log back in."));
    }
}

