/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.AuthResolver;
import com.axelor.auth.AuthSecurityException;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.JPQLFilter;
import com.axelor.script.GroovyScriptHelper;
import com.axelor.script.ScriptBindings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.authz.UnauthorizedException;

@Singleton
class AuthSecurity
implements JpaSecurity,
Provider<JpaSecurity> {
    private AuthResolver authResolver = new AuthResolver();

    AuthSecurity() {
    }

    private User getUser() {
        User user = AuthUtils.getUser();
        if (user == null || AuthUtils.isAdmin(user)) {
            return null;
        }
        return user;
    }

    private Condition getCondition(User user, Permission permission, JpaSecurity.AccessType accessType) {
        String condition = permission.getCondition();
        String params = permission.getConditionParams();
        if (condition == null || "".equals(condition.trim())) {
            return null;
        }
        return new Condition(user, condition, params);
    }

    @Override
    public boolean hasRole(String name) {
        User user = this.getUser();
        if (user == null) {
            return true;
        }
        return AuthUtils.hasRole(user, name);
    }

    @Override
    public Set<JpaSecurity.AccessType> getAccessTypes(Class<? extends Model> model, Long id) {
        HashSet types = Sets.newHashSet();
        for (JpaSecurity.AccessType type : JpaSecurity.AccessType.values()) {
            if (!this.isPermitted(type, model, id)) continue;
            types.add(type);
        }
        return types;
    }

    @Override
    public Filter getFilter(JpaSecurity.AccessType type, Class<? extends Model> model, Long ... ids) {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        ArrayList filters = Lists.newArrayList();
        Set<Permission> permissions = this.authResolver.resolve(user, model.getName(), type);
        if (permissions.isEmpty()) {
            return null;
        }
        for (Permission permission : permissions) {
            Condition condition = this.getCondition(user, permission, type);
            if (condition == null) continue;
            filters.add(condition.getFilter());
        }
        if (filters.isEmpty() && ids.length == 0) {
            return null;
        }
        Filter left = filters.isEmpty() ? null : Filter.or(filters);
        Filter right = null;
        if (ids != null && ids.length > 0 && ids[0] != null) {
            right = Filter.in("id", Lists.newArrayList((Object[])ids));
        }
        if (right == null) {
            return left;
        }
        if (left == null) {
            return right;
        }
        return Filter.and(left, right, new Filter[0]);
    }

    @Override
    public boolean isPermitted(JpaSecurity.AccessType type, Class<? extends Model> model, Long ... ids) {
        User user = this.getUser();
        if (user == null) {
            return true;
        }
        Set<Permission> permissions = this.authResolver.resolve(user, model.getName(), type);
        if (permissions.isEmpty()) {
            return false;
        }
        for (Permission permission : permissions) {
            if (permission.getCondition() != null || !this.authResolver.hasAccess(permission, type)) continue;
            return true;
        }
        if (ids == null || ids.length == 0) {
            return true;
        }
        Filter filter = this.getFilter(type, model, ids);
        if (filter == null) {
            return true;
        }
        return filter.build(model).count() == (long)ids.length;
    }

    @Override
    public void check(JpaSecurity.AccessType type, Class<? extends Model> model, Long ... ids) {
        if (this.isPermitted(type, model, ids)) {
            return;
        }
        AuthSecurityException cause = new AuthSecurityException(type, model, ids);
        throw new UnauthorizedException(cause.getMessage(), (Throwable)cause);
    }

    public JpaSecurity get() {
        return new AuthSecurity();
    }

    private static final class Condition {
        private Filter filter;

        public Condition(User user, String condition, String params) {
            ArrayList args = Lists.newArrayList();
            if (StringUtils.notBlank((CharSequence)params)) {
                for (String param : params.split(",")) {
                    if ("__user__".equals(param = param.trim())) {
                        args.add(user);
                        continue;
                    }
                    Object value = this.eval(user, "__user__", param);
                    args.add(value);
                }
            }
            this.filter = new JPQLFilter(condition, args.toArray());
        }

        private Object eval(Object bean, String prefix, String expr) {
            if (bean == null) {
                return null;
            }
            return new GroovyScriptHelper(new ScriptBindings(Collections.singletonMap(prefix, bean))).eval(expr);
        }

        public Filter getFilter() {
            return this.filter;
        }

        public String toString() {
            return this.filter.getQuery();
        }
    }
}

