/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthSessionService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.crypto.hash.format.HashFormat;
import org.apache.shiro.crypto.hash.format.ParsableHashFormat;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;

@Singleton
public class AuthService {
    private static final String HASH_ALGORITHM = "SHA-512";
    private static final int HASH_ITERATIONS = 500000;
    private final DefaultPasswordService passwordService = new DefaultPasswordService();
    private final DefaultHashService hashService = new DefaultHashService();
    private final ParsableHashFormat hashFormat = new Shiro1CryptFormat();
    private static final String PASSWORD_PATTERN;
    private static final String PASSWORD_PATTERN_TITLE;
    private static final Pattern passwordPattern;

    @Inject
    public AuthService() {
        this.hashService.setHashAlgorithmName(HASH_ALGORITHM);
        this.hashService.setHashIterations(500000);
        this.hashService.setGeneratePublicSalt(true);
        this.passwordService.setHashService((HashService)this.hashService);
        this.passwordService.setHashFormat((HashFormat)this.hashFormat);
    }

    public static AuthService getInstance() {
        try {
            return Beans.get(AuthService.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("AuthService is not initialized, did you forget to bind the AuthService?");
        }
    }

    public String encrypt(String password) {
        try {
            this.hashFormat.parse(password);
            return password;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.passwordService.encryptPassword((Object)password);
        }
    }

    public User encrypt(User user) {
        user.setPassword(this.encrypt(user.getPassword()));
        return user;
    }

    public Object encrypt(Object user, Map context) {
        if (user instanceof User) {
            return this.encrypt((User)user);
        }
        return user;
    }

    public boolean match(String plain, String saved) {
        return this.passwordService.passwordsMatch((Object)plain, saved);
    }

    public void checkPassword(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Map<String, Object> data = context == null ? request.getData() : context;
        String username = (String)data.getOrDefault("username", data.get("code"));
        String password = (String)data.getOrDefault("password", data.get("newPassword"));
        User user = AuthUtils.getUser(username);
        if (user == null || !this.match(password, user.getPassword())) {
            response.setStatus(ActionResponse.STATUS_FAILURE);
            response.setError("No such user or password doesn't match.");
            return;
        }
        Mapper mapper = Mapper.of(User.class);
        Property name = mapper.getNameField();
        response.setValue("id", user.getId());
        response.setValue("name", name.get(user));
        response.setValue("nameField", name.getName());
        response.setValue("login", user.getCode());
        response.setValue("lang", user.getLanguage());
    }

    public void changePassword(User user, String password) {
        Preconditions.checkArgument((boolean)this.passwordMatchesPattern(password), (Object)PASSWORD_PATTERN_TITLE);
        user.setPassword(this.encrypt(password));
        user.setPasswordUpdatedOn(LocalDateTime.now());
        User authUser = AuthUtils.getUser();
        if (authUser != null && authUser.getId().equals(user.getId())) {
            Beans.get(AuthSessionService.class).updateLoginDate();
        }
    }

    public boolean passwordMatchesPattern(String password) {
        return passwordPattern.matcher(password).matches();
    }

    public String getPasswordPattern() {
        return PASSWORD_PATTERN;
    }

    public String getPasswordPatternTitle() {
        return I18n.get(PASSWORD_PATTERN_TITLE);
    }

    static {
        AppSettings settings = AppSettings.get();
        PASSWORD_PATTERN = settings.get("user.password.pattern", ".{4,}");
        PASSWORD_PATTERN_TITLE = settings.get("user.password.pattern.title", "user.password.pattern.title");
        passwordPattern = Pattern.compile(PASSWORD_PATTERN);
    }
}

