/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth;

import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.QueryBinder;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.subject.Subject;

public class AuthUtils {
    private static final String QS_HAS_ROLE = "SELECT self.id FROM Role self WHERE (self.name IN (:roles)) AND (  (self.id IN (SELECT r.id FROM User u LEFT JOIN u.roles AS r WHERE u.code = :user)) OR   (self.id IN (SELECT r.id FROM User u LEFT JOIN u.group AS g LEFT JOIN g.roles AS r WHERE u.code = :user)))";

    public static Subject getSubject() {
        try {
            return SecurityUtils.getSubject();
        }
        catch (UnavailableSecurityManagerException unavailableSecurityManagerException) {
            return null;
        }
    }

    public static User getUser() {
        try {
            return AuthUtils.getUser(AuthUtils.getSubject().getPrincipal().toString());
        }
        catch (NullPointerException | InvalidSessionException throwable) {
            return null;
        }
    }

    public static User getUser(String code) {
        if (code == null) {
            return null;
        }
        return JpaRepository.of(User.class).all().filter("self.code = ?", code).cacheable().autoFlush(false).fetchOne();
    }

    public static boolean isActive(User user) {
        if (user.getArchived() == Boolean.TRUE || user.getBlocked() == Boolean.TRUE) {
            return false;
        }
        LocalDateTime from = user.getActivateOn();
        LocalDateTime till = user.getExpiresOn();
        LocalDateTime now = LocalDateTime.now();
        return (from == null || !from.isAfter(now)) && (till == null || !till.isBefore(now));
    }

    public static boolean isAdmin(User user) {
        return "admin".equals(user.getCode()) || user.getGroup() != null && "admins".equals(user.getGroup().getCode());
    }

    public static boolean isTechnicalStaff(User user) {
        return user.getGroup() != null && user.getGroup().getTechnicalStaff() == Boolean.TRUE;
    }

    public static boolean hasRole(User user, String ... roles) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"user not provided.");
        Preconditions.checkArgument((roles != null ? 1 : 0) != 0, (Object)"roles not provided.");
        Preconditions.checkArgument((roles.length > 0 ? 1 : 0) != 0, (Object)"roles not provided.");
        TypedQuery query = JPA.em().createQuery(QS_HAS_ROLE, Long.class);
        query.setParameter("roles", Arrays.asList(roles));
        query.setParameter("user", (Object)user.getCode());
        query.setMaxResults(1);
        QueryBinder.of((Query)query).opts(true, FlushModeType.COMMIT);
        List ids = query.getResultList();
        return ids != null && ids.size() == 1;
    }
}

