/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.auth.UserAuthenticationInfo;
import com.axelor.auth.db.User;
import com.axelor.event.Event;
import com.axelor.event.NamedLiteral;
import com.axelor.events.PostLogin;
import com.axelor.inject.Beans;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPac4jListener
implements AuthenticationListener {
    @Inject
    private Event<PostLogin> postLogin;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void onSuccess(AuthenticationToken token, AuthenticationInfo info) {
        User user;
        if (info instanceof UserAuthenticationInfo && (user = ((UserAuthenticationInfo)info).getUser()) != null) {
            Beans.get(HttpServletRequest.class).changeSessionId();
            this.firePostLoginSuccess(token, user);
            return;
        }
        logger.error("No active user found for principal: {}", token.getPrincipal());
        this.firePostLoginFailure(token, (AuthenticationException)new UnknownAccountException(info.toString()));
        SecurityUtils.getSubject().logout();
    }

    public void onFailure(AuthenticationToken token, AuthenticationException ae) {
        logger.error("Authentication failed for principal: {}", token.getPrincipal());
        this.firePostLoginFailure(token, ae);
    }

    public void onLogout(PrincipalCollection principals) {
    }

    private void firePostLoginSuccess(AuthenticationToken token, User user) {
        this.postLogin.select(new Annotation[]{NamedLiteral.of("success")}).fire(new PostLogin(token, user, null));
    }

    private void firePostLoginFailure(AuthenticationToken token, AuthenticationException ae) {
        this.postLogin.select(new Annotation[]{NamedLiteral.of("failure")}).fire(new PostLogin(token, null, ae));
    }
}

