/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthFilter;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.AuthWebModule;
import com.axelor.auth.pac4j.AuthPac4jListener;
import com.axelor.auth.pac4j.AuthPac4jModuleCas;
import com.axelor.auth.pac4j.AuthPac4jRealm;
import com.axelor.common.StringUtils;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import io.buji.pac4j.engine.ShiroCallbackLogic;
import io.buji.pac4j.engine.ShiroSecurityLogic;
import io.buji.pac4j.filter.CallbackFilter;
import io.buji.pac4j.filter.LogoutFilter;
import io.buji.pac4j.filter.SecurityFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.csrf.CsrfAuthorizer;
import org.pac4j.core.authorization.authorizer.csrf.CsrfTokenGenerator;
import org.pac4j.core.authorization.authorizer.csrf.DefaultCsrfTokenGenerator;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.http.client.indirect.FormClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthPac4jModule
extends AuthWebModule {
    private static final List<Client> clientList = new ArrayList<Client>();
    private static final Map<String, Map<String, String>> clientInfo = new HashMap<String, Map<String, String>>();
    private static final Set<String> centralClientNames = new LinkedHashSet<String>();
    private static String callbackUrl;
    private static boolean absCallbackUrlRequired;
    private static String logoutUrl;
    private static final String CSRF_TOKEN_AUTHORIZER_NAME = "axelorCsrfToken";
    private static final String CSRF_AUTHORIZER_NAME = "axelorCsrf";
    private static final String CSRF_COOKIE_NAME = "CSRF-TOKEN";
    private static final String CSRF_HEADER_NAME = "X-CSRF-Token";
    private static final String HASH_LOCATION_PARAMETER = "hash_location";
    private static final Logger logger;

    public AuthPac4jModule(ServletContext servletContext) {
        super(servletContext);
        logger.info("Loading pac4j: {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    @Nullable
    public static Map<String, String> getClientInfo(String clientName) {
        return clientInfo.get(clientName);
    }

    protected static void setClientInfo(String clientName, Map<String, String> info) {
        clientInfo.put(clientName, info);
    }

    @Override
    protected void configureAuth() {
        this.configureClients();
        Multibinder listenerMultibinder = Multibinder.newSetBinder((Binder)this.binder(), AuthenticationListener.class);
        listenerMultibinder.addBinding().to(AuthPac4jListener.class);
        this.bind(Config.class).toProvider(ConfigProvider.class);
        this.bindRealm().to(AuthPac4jRealm.class);
        this.addFilterChain("/login.jsp", Key.get(AxelorLoginPageFilter.class));
        this.addFilterChain("/logout", Key.get(AxelorLogoutFilter.class));
        this.addFilterChain("/callback", Key.get(AxelorCallbackFilter.class));
        this.addFilterChain("/**", Key.get(AxelorSecurityFilter.class));
    }

    protected abstract void configureClients();

    protected void addLocalClient(Client<?, ?> client) {
        Preconditions.checkState((boolean)centralClientNames.isEmpty(), (Object)"Local clients must be added before central clients.");
        this.addClient(client);
        logger.info("Added local client: {}", (Object)client.getName());
    }

    protected void addCentralClient(Client<?, ?> client) {
        this.addClient(client);
        centralClientNames.add(client.getName());
        logger.info("Added central client: {}", (Object)client.getName());
    }

    private void addClient(Client<?, ?> client) {
        clientList.add(client);
    }

    public static Set<String> getCentralClients() {
        return centralClientNames;
    }

    public static String getRelativeBaseURL() {
        String base = AppSettings.get().getBaseURL();
        return URI.create(base).getPath();
    }

    public static String getCallbackUrl() {
        if (callbackUrl == null) {
            AppSettings settings = AppSettings.get();
            callbackUrl = settings.get("auth.callback.url", null);
            if (StringUtils.isBlank((CharSequence)callbackUrl) && AuthPac4jModuleCas.isEnabled()) {
                callbackUrl = settings.get("auth.cas.service", null);
            }
            if (StringUtils.isBlank((CharSequence)callbackUrl)) {
                String base = AppSettings.get().getBaseURL();
                if (!absCallbackUrlRequired) {
                    base = URI.create(base).getPath();
                }
                callbackUrl = base + "/callback";
            }
        }
        return callbackUrl;
    }

    public static void requireAbsCallbackUrl() {
        absCallbackUrlRequired = true;
    }

    public static String getLogoutUrl() {
        if (logoutUrl == null) {
            AppSettings settings = AppSettings.get();
            logoutUrl = settings.get("auth.logout.url", null);
            if (StringUtils.isBlank((CharSequence)logoutUrl)) {
                String string = logoutUrl = AuthPac4jModuleCas.isEnabled() ? settings.get("auth.cas.logout.url", AuthPac4jModule.getRelativeBaseURL()) : AuthPac4jModule.getRelativeBaseURL();
            }
            if (StringUtils.isBlank((CharSequence)logoutUrl)) {
                logoutUrl = ".";
            }
        }
        return logoutUrl;
    }

    protected void bindWebSecurityManager(AnnotatedBindingBuilder<? super WebSecurityManager> bind) {
        bind.to(DefaultWebSecurityManager.class);
    }

    @Provides
    protected DefaultWebSecurityManager provideDefaultSecurityManager(Collection<Realm> realms, Set<AuthenticationListener> authenticationListeners) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager(realms);
        ModularRealmAuthenticator authenticator = new ModularRealmAuthenticator();
        authenticator.setRealms(realms);
        authenticator.setAuthenticationListeners(authenticationListeners);
        securityManager.setAuthenticator((Authenticator)authenticator);
        return securityManager;
    }

    protected static boolean isXHR(WebContext context) {
        return context instanceof J2EContext && AuthPac4jModule.isXHR(((J2EContext)context).getRequest());
    }

    protected static boolean isXHR(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With")) || "application/json".equals(request.getHeader("Accept")) || "application/json".equals(request.getHeader("Content-Type"));
    }

    protected static boolean isNativeClient(WebContext context) {
        String origin = context.getRequestHeader("Origin");
        return StringUtils.isBlank((CharSequence)origin);
    }

    static {
        logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }

    private static class AxelorLoginPageFilter
    implements Filter {
        @Inject
        private AxelorCallbackFilter axelorCallbackFilter;

        private AxelorLoginPageFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            AuthFilter.setSameSiteNone((HttpServletRequest)request, (HttpServletResponse)response);
            Subject subject = SecurityUtils.getSubject();
            boolean authenticated = subject.isAuthenticated();
            if (authenticated && AuthUtils.getUser() == null) {
                subject.logout();
            }
            if (authenticated || clientList.stream().noneMatch(client -> client instanceof FormClient)) {
                ((HttpServletResponse)response).sendRedirect(".");
                return;
            }
            if (request.getContentLengthLong() > 0L) {
                this.axelorCallbackFilter.doFilter(request, response, chain);
                return;
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    private static class AxelorSecurityFilter
    extends SecurityFilter {
        @Inject
        public AxelorSecurityFilter(Config config) {
            this.setConfig(config);
            this.setAuthorizers(config.getAuthorizers().keySet().stream().collect(Collectors.joining(",")));
            String clientNames = config.getClients().getClients().stream().map(Client::getName).collect(Collectors.joining(","));
            this.setClients(clientNames);
            this.setSecurityLogic((SecurityLogic)new ShiroSecurityLogic<Object, J2EContext>(){

                public Object perform(J2EContext context, Config config, SecurityGrantedAccessAdapter<Object, J2EContext> securityGrantedAccessAdapter, HttpActionAdapter<Object, J2EContext> httpActionAdapter, String clients, String authorizers, String matchers, Boolean inputMultiProfile, Object ... parameters) {
                    AuthFilter.setSameSiteNone(context.getRequest(), context.getResponse());
                    return super.perform((WebContext)context, config, securityGrantedAccessAdapter, httpActionAdapter, clients, authorizers, matchers, inputMultiProfile, parameters);
                }

                protected void saveRequestedUrl(J2EContext context, List<Client> currentClients) {
                    String clientName;
                    String hashLocation = context.getRequestParameter(AuthPac4jModule.HASH_LOCATION_PARAMETER);
                    if (StringUtils.notBlank((CharSequence)hashLocation)) {
                        context.getSessionStore().set((WebContext)context, AuthPac4jModule.HASH_LOCATION_PARAMETER, (Object)hashLocation);
                    }
                    if (StringUtils.isBlank((CharSequence)(clientName = context.getRequestParameter("client_name"))) || currentClients.size() != 1 || !centralClientNames.contains(currentClients.get(0).getName())) {
                        super.saveRequestedUrl((WebContext)context, currentClients);
                    }
                }
            });
        }
    }

    private static class AxelorCallbackFilter
    extends CallbackFilter {
        @Inject
        public AxelorCallbackFilter(final Config config) {
            this.setConfig(config);
            AppSettings settings = AppSettings.get();
            String defaultUrl = settings.getBaseURL();
            if (StringUtils.notBlank((CharSequence)defaultUrl)) {
                this.setDefaultUrl(defaultUrl);
            }
            this.setDefaultClient(((Client)config.getClients().getClients().get(0)).getName());
            this.setCallbackLogic((CallbackLogic)new ShiroCallbackLogic<Object, J2EContext>(){

                public Object perform(J2EContext context, Config config2, HttpActionAdapter<Object, J2EContext> httpActionAdapter, String inputDefaultUrl, Boolean inputSaveInSession, Boolean inputMultiProfile, Boolean inputRenewSession, String client) {
                    AuthFilter.setSameSiteNone(context.getRequest(), context.getResponse());
                    try {
                        context.getRequest().setCharacterEncoding("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    return super.perform((WebContext)context, config2, httpActionAdapter, inputDefaultUrl, inputSaveInSession, inputMultiProfile, inputRenewSession, client);
                }

                protected HttpAction redirectToOriginallyRequestedUrl(J2EContext context, String defaultUrl) {
                    String hashLocation;
                    AxelorCsrfTokenGeneratorAuthorizer csrfTokenAuthorizer = (AxelorCsrfTokenGeneratorAuthorizer)config.getAuthorizers().get(AuthPac4jModule.CSRF_TOKEN_AUTHORIZER_NAME);
                    csrfTokenAuthorizer.addResponseCookieAndHeader((WebContext)context);
                    if (AuthPac4jModule.isXHR((WebContext)context)) {
                        return HttpAction.status((int)200, (WebContext)context);
                    }
                    String requestedUrl = (String)context.getSessionStore().get((WebContext)context, "pac4jRequestedUrl");
                    String redirectUrl = defaultUrl;
                    if (StringUtils.notBlank((CharSequence)requestedUrl)) {
                        context.getSessionStore().set((WebContext)context, "pac4jRequestedUrl", null);
                        redirectUrl = requestedUrl;
                    }
                    if (StringUtils.isBlank((CharSequence)(hashLocation = context.getRequestParameter(AuthPac4jModule.HASH_LOCATION_PARAMETER)))) {
                        hashLocation = (String)context.getSessionStore().get((WebContext)context, AuthPac4jModule.HASH_LOCATION_PARAMETER);
                    }
                    if (StringUtils.notBlank((CharSequence)hashLocation)) {
                        redirectUrl = redirectUrl + hashLocation;
                    }
                    this.logger.debug("redirectUrl: {}", (Object)redirectUrl);
                    return HttpAction.redirect((WebContext)context, (String)redirectUrl);
                }
            });
        }
    }

    private static class AxelorLogoutFilter
    extends LogoutFilter {
        @Inject
        public AxelorLogoutFilter(Config config) {
            AppSettings settings = AppSettings.get();
            String logoutUrlPattern = settings.get("auth.logout.url.pattern", null);
            boolean localLogout = settings.getBoolean("auth.logout.local", true);
            boolean centralLogout = settings.getBoolean("auth.logout.central", false);
            this.setConfig(config);
            this.setDefaultUrl(AuthPac4jModule.getLogoutUrl());
            this.setLogoutUrlPattern(logoutUrlPattern);
            this.setLocalLogout(localLogout);
            this.setCentralLogout(centralLogout);
            this.setLogoutLogic((LogoutLogic)new DefaultLogoutLogic<Object, J2EContext>(){

                public Object perform(J2EContext context, Config config, HttpActionAdapter<Object, J2EContext> httpActionAdapter, String defaultUrl, String inputLogoutUrlPattern, Boolean inputLocalLogout, Boolean inputDestroySession, Boolean inputCentralLogout) {
                    AuthFilter.setSameSiteNone(context.getRequest(), context.getResponse());
                    return super.perform((WebContext)context, config, httpActionAdapter, defaultUrl, inputLogoutUrlPattern, inputLocalLogout, Boolean.valueOf(true), inputCentralLogout);
                }
            });
        }
    }

    private static class AxelorCsrfAuthorizer
    extends CsrfAuthorizer {
        public AxelorCsrfAuthorizer() {
            super(AuthPac4jModule.CSRF_HEADER_NAME, AuthPac4jModule.CSRF_HEADER_NAME);
        }

        public boolean isAuthorized(WebContext context, List<CommonProfile> profiles) {
            return AuthPac4jModule.isNativeClient(context) || super.isAuthorized(context, profiles);
        }
    }

    private static class AxelorCsrfTokenGeneratorAuthorizer
    implements Authorizer<CommonProfile> {
        private final CsrfTokenGenerator tokenGenerator = new DefaultCsrfTokenGenerator();

        private AxelorCsrfTokenGeneratorAuthorizer() {
        }

        public boolean isAuthorized(WebContext context, List<CommonProfile> profiles) {
            if (AuthPac4jModule.isNativeClient(context)) {
                return true;
            }
            this.addResponseCookieAndHeader(context);
            return true;
        }

        private void addResponseCookieAndHeader(WebContext context) {
            String token = this.tokenGenerator.get(context);
            Cookie cookie = new Cookie(AuthPac4jModule.CSRF_COOKIE_NAME, token);
            String path = ((J2EContext)context).getRequest().getContextPath();
            if (path.length() == 0) {
                path = "/";
            }
            cookie.setDomain("");
            cookie.setPath(path);
            context.addResponseCookie(cookie);
            J2EContext j2eContext = (J2EContext)context;
            AuthFilter.setSameSiteNone(j2eContext.getRequest(), j2eContext.getResponse());
            context.setResponseHeader(AuthPac4jModule.CSRF_HEADER_NAME, token);
        }
    }

    @Singleton
    private static class ConfigProvider
    implements Provider<Config> {
        private Config config;

        @Inject
        public ConfigProvider() {
            Clients clients = new Clients(AuthPac4jModule.getCallbackUrl(), clientList);
            LinkedHashMap<String, Object> authorizers = new LinkedHashMap<String, Object>();
            authorizers.put(AuthPac4jModule.CSRF_TOKEN_AUTHORIZER_NAME, new AxelorCsrfTokenGeneratorAuthorizer());
            authorizers.put(AuthPac4jModule.CSRF_AUTHORIZER_NAME, (Object)new AxelorCsrfAuthorizer());
            this.config = new Config(clients, Collections.unmodifiableMap(authorizers));
        }

        public Config get() {
            return this.config;
        }
    }
}

