/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.pac4j.AuthPac4jModule;
import java.lang.invoke.MethodHandles;
import javax.servlet.ServletContext;
import org.jasig.cas.client.validation.TicketValidator;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.client.CasProxyReceptor;
import org.pac4j.cas.client.direct.DirectCasClient;
import org.pac4j.cas.client.direct.DirectCasProxyClient;
import org.pac4j.cas.client.rest.CasRestBasicAuthClient;
import org.pac4j.cas.client.rest.CasRestFormClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.client.Client;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.logout.handler.LogoutHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPac4jModuleCas
extends AuthPac4jModule {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AuthPac4jModuleCas(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    protected void configureClients() {
        DirectCasClient client;
        AppSettings settings = AppSettings.get();
        String loginUrl = settings.get("auth.cas.login.url");
        String prefixUrl = settings.get("auth.cas.prefix.url", settings.get("auth.cas.server.url.prefix", null));
        String protocol = settings.get("auth.cas.protocol", null);
        String encoding = settings.get("auth.cas.encoding", null);
        boolean renew = settings.getBoolean("auth.cas.renew", false);
        boolean gateway = settings.getBoolean("auth.cas.gateway", false);
        long timeTolerance = settings.getInt("auth.cas.time.tolerance", 1000);
        String urlResolverClass = settings.get("auth.cas.url.resolver.class", null);
        String defaultTicketValidatorClass = settings.get("auth.cas.default.ticket.validator.class", null);
        boolean proxySupport = settings.getBoolean("auth.cas.proxy.support", false);
        String logoutHandlerClass = settings.get("auth.cas.logout.handler.class", null);
        String clientType = settings.get("auth.cas.client.type", "indirect");
        CasConfiguration casConfig = new CasConfiguration(loginUrl);
        if (prefixUrl != null) {
            casConfig.setPrefixUrl(prefixUrl);
        }
        if (protocol != null) {
            casConfig.setProtocol(CasProtocol.valueOf((String)protocol));
        }
        if (encoding != null) {
            casConfig.setEncoding(encoding);
        }
        casConfig.setRenew(renew);
        casConfig.setGateway(gateway);
        casConfig.setTimeTolerance(timeTolerance);
        if (urlResolverClass != null) {
            try {
                UrlResolver urlResorver = (UrlResolver)Class.forName(urlResolverClass).newInstance();
                casConfig.setUrlResolver(urlResorver);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (defaultTicketValidatorClass != null) {
            try {
                TicketValidator defaultTicketValidator = (TicketValidator)Class.forName(defaultTicketValidatorClass).newInstance();
                casConfig.setDefaultTicketValidator(defaultTicketValidator);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (proxySupport) {
            CasProxyReceptor casProxy = new CasProxyReceptor();
            casConfig.setProxyReceptor(casProxy);
        }
        if (logoutHandlerClass != null) {
            try {
                LogoutHandler logoutHandler = (LogoutHandler)Class.forName(logoutHandlerClass).newInstance();
                casConfig.setLogoutHandler(logoutHandler);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        switch (clientType) {
            case "direct": {
                client = new DirectCasClient(casConfig);
                break;
            }
            case "direct-proxy": {
                String serviceUrl = settings.get("auth.cas.service.url", null);
                client = new DirectCasProxyClient(casConfig, serviceUrl);
                break;
            }
            case "rest-form": {
                String usernameParameter = settings.get("auth.cas.username.parameter", "username");
                String passwordParameter = settings.get("auth.cas.password.parameter", "password");
                client = new CasRestFormClient(casConfig, usernameParameter, passwordParameter);
                break;
            }
            case "rest-basic-auth": {
                String headerName = settings.get("auth.cas.header.name", "Authorization");
                String prefixHeader = settings.get("auth.cas.prefix.header", "Basic");
                client = new CasRestBasicAuthClient(casConfig, headerName, prefixHeader.trim() + " ");
                break;
            }
            default: {
                CasClient casClient = new CasClient(casConfig);
                casClient.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
                client = casClient;
            }
        }
        this.addCentralClient((Client<?, ?>)client);
    }

    public static boolean isEnabled() {
        AppSettings settings = AppSettings.get();
        return settings.get("auth.cas.login.url", null) != null;
    }
}

