/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.auth.pac4j.AuthPac4jModule;
import com.axelor.auth.pac4j.AxelorLdapProfileService;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.inject.Beans;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import javax.servlet.ServletContext;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.http.ajax.DefaultAjaxRequestResolver;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.client.direct.DirectBasicAuthClient;
import org.pac4j.http.client.indirect.FormClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPac4jModuleLocal
extends AuthPac4jModule {
    private static final String INCORRECT_CREDENTIALS = "Wrong username or password";
    private static final String WRONG_CURRENT_PASSWORD = "Wrong current password";
    private static final String CHANGE_PASSWORD = "Please change your password.";
    private static final String NEW_PASSWORD_PARAMETER = "newPassword";
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public AuthPac4jModuleLocal(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    protected void configureClients() {
        this.addLocalClients();
    }

    @Override
    protected void configureAnon() {
        super.configureAnon();
        this.addFilterChain("/login.jsp", ANON);
        this.addFilterChain("/change-password.jsp", ANON);
    }

    protected void addLocalClients() {
        AppSettings settings = AppSettings.get();
        String ldapUrl = settings.get("auth.ldap.server.url", null);
        if (ldapUrl != null) {
            this.bind(AxelorAuthenticator.class).to(AxelorLdapProfileService.class);
            logger.info("LDAP URL: {}", (Object)ldapUrl);
        } else {
            this.bind(AxelorAuthenticator.class).to(AxelorLocalAuthenticator.class);
        }
        this.expose(AxelorAuthenticator.class);
        this.addLocalClient((Client<?, ?>)new AxelorFormClient());
        if (AuthPac4jModuleLocal.isBasicAuthEnabled()) {
            this.addLocalClient((Client<?, ?>)new AxelorDirectBasicAuthClient());
        }
    }

    public static boolean isLdapEnabled() {
        AppSettings settings = AppSettings.get();
        return settings.get("auth.ldap.server.url", null) != null;
    }

    public static boolean isBasicAuthEnabled() {
        AppSettings settings = AppSettings.get();
        return settings.getBoolean("auth.local.basic.auth.enabled", false);
    }

    private static class JsonExtractor
    extends FormExtractor {
        public JsonExtractor() {
            super("username", "password");
        }

        public UsernamePasswordCredentials extract(WebContext context) {
            return AuthPac4jModule.isXHR(context) ? this.extractJson(context) : super.extract(context);
        }

        private UsernamePasswordCredentials extractJson(WebContext context) {
            Map data;
            try {
                data = (Map)new ObjectMapper().readValue(context.getRequestContent(), Map.class);
            }
            catch (IOException e) {
                return null;
            }
            String username = (String)data.get("username");
            String password = (String)data.get("password");
            if (username == null || password == null) {
                return null;
            }
            return new UsernamePasswordCredentials(username, password);
        }
    }

    private static class AxelorAjaxRequestResolver
    extends DefaultAjaxRequestResolver {
        private AxelorAjaxRequestResolver() {
        }

        public boolean isAjax(WebContext context) {
            return super.isAjax(context) || AuthPac4jModule.isXHR(context);
        }

        public RedirectAction buildAjaxResponse(String url, WebContext context) {
            if (this.isAjax(context) && StringUtils.notBlank((CharSequence)url) && url.equals("login.jsp")) {
                throw HttpAction.unauthorized((WebContext)context);
            }
            return super.buildAjaxResponse(url, context);
        }
    }

    public static class AxelorLocalAuthenticator
    implements AxelorAuthenticator {
        public void validate(UsernamePasswordCredentials credentials, WebContext context) {
            if (credentials == null) {
                throw new CredentialsException("No credentials");
            }
            String username = credentials.getUsername();
            String password = credentials.getPassword();
            if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
                throw new CredentialsException(AuthPac4jModuleLocal.INCORRECT_CREDENTIALS);
            }
            User user = AuthUtils.getUser(username);
            if (user == null) {
                throw new CredentialsException(AuthPac4jModuleLocal.INCORRECT_CREDENTIALS);
            }
            AuthService authService = AuthService.getInstance();
            String newPassword = context.getRequestParameter(AuthPac4jModuleLocal.NEW_PASSWORD_PARAMETER);
            if (!authService.match(password, user.getPassword())) {
                if (StringUtils.isBlank((CharSequence)newPassword)) {
                    throw new CredentialsException(AuthPac4jModuleLocal.INCORRECT_CREDENTIALS);
                }
                throw new CredentialsException(AuthPac4jModuleLocal.WRONG_CURRENT_PASSWORD);
            }
            if (Boolean.TRUE.equals(user.getForcePasswordChange())) {
                if (StringUtils.isBlank((CharSequence)newPassword)) {
                    throw new CredentialsException(AuthPac4jModuleLocal.CHANGE_PASSWORD);
                }
                JPA.runInTransaction(() -> {
                    try {
                        Beans.get(AuthService.class).changePassword(user, newPassword);
                    }
                    catch (IllegalArgumentException e) {
                        throw new CredentialsException(e.getMessage());
                    }
                    user.setForcePasswordChange(false);
                });
            }
            CommonProfile profile = new CommonProfile();
            profile.setId(username);
            profile.addAttribute("username", (Object)username);
            credentials.setUserProfile(profile);
        }
    }

    public static interface AxelorAuthenticator
    extends Authenticator<UsernamePasswordCredentials> {
    }

    private static class AxelorDirectBasicAuthClient
    extends DirectBasicAuthClient {
        public AxelorDirectBasicAuthClient() {
            this.setName(((Object)((Object)this)).getClass().getSuperclass().getSimpleName());
        }

        protected void clientInit() {
            Authenticator authenticator = Beans.get(AxelorAuthenticator.class);
            this.defaultAuthenticator(authenticator);
            super.clientInit();
        }

        protected UsernamePasswordCredentials retrieveCredentials(WebContext context) {
            if (StringUtils.isBlank((CharSequence)context.getRequestHeader("Authorization"))) {
                return null;
            }
            return super.retrieveCredentials(context);
        }
    }

    private static class AxelorFormClient
    extends FormClient {
        public AxelorFormClient() {
            this.setName(((Object)((Object)this)).getClass().getSuperclass().getSimpleName());
            this.setCredentialsExtractor((CredentialsExtractor)new JsonExtractor());
            this.setAjaxRequestResolver((AjaxRequestResolver)new AxelorAjaxRequestResolver());
        }

        protected void clientInit() {
            String baseUrl = AuthPac4jModule.getRelativeBaseURL();
            String loginUrl = baseUrl + "/login.jsp";
            this.setLoginUrl(loginUrl);
            Authenticator authenticator = Beans.get(AxelorAuthenticator.class);
            this.defaultAuthenticator(authenticator);
            super.clientInit();
        }

        protected UsernamePasswordCredentials retrieveCredentials(WebContext context) {
            UsernamePasswordCredentials credentials;
            CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
            CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
            String username = context.getRequestParameter(this.getUsernameParameter());
            try {
                credentials = (UsernamePasswordCredentials)this.getCredentialsExtractor().extract(context);
                this.logger.debug("usernamePasswordCredentials: {}", (Object)credentials);
                if (credentials == null) {
                    throw this.handleInvalidCredentials(context, username, "Username and password cannot be blank -> return to the form with error", "missing_field");
                }
                if (username == null) {
                    username = credentials.getUsername();
                }
                this.getAuthenticator().validate((Credentials)credentials, context);
            }
            catch (CredentialsException e) {
                throw this.handleInvalidCredentials(context, username, "Credentials validation fails -> return to the form with error", this.computeErrorMessage((Exception)((Object)e)));
            }
            return credentials;
        }

        protected String computeErrorMessage(Exception e) {
            return e.getMessage();
        }

        protected HttpAction handleInvalidCredentials(WebContext context, String username, String message, String errorMessage) {
            if (AuthPac4jModuleLocal.CHANGE_PASSWORD.equals(errorMessage) || StringUtils.notBlank((CharSequence)context.getRequestParameter(AuthPac4jModuleLocal.NEW_PASSWORD_PARAMETER))) {
                String tenantId = context.getRequestParameter("tenantId");
                if (StringUtils.notBlank((CharSequence)tenantId)) {
                    SessionStore sessionStore = context.getSessionStore();
                    sessionStore.set(context, "tenantId", (Object)tenantId);
                }
                String redirectionUrl = CommonHelper.addParameter((String)"change-password.jsp", (String)this.getUsernameParameter(), (String)username);
                redirectionUrl = CommonHelper.addParameter((String)redirectionUrl, (String)"error", (String)errorMessage);
                return HttpAction.redirect((WebContext)context, (String)redirectionUrl);
            }
            this.logger.error("Password authentication failed for user: {}", (Object)username);
            return super.handleInvalidCredentials(context, username, message, errorMessage);
        }
    }
}

