/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.auth.pac4j.AuthPac4jModuleMultiClient;
import com.axelor.common.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletContext;
import org.pac4j.core.client.Client;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.http.client.direct.HeaderClient;
import org.pac4j.oidc.client.AzureAdClient;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.KeycloakOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.AzureAdOidcConfiguration;
import org.pac4j.oidc.config.KeycloakOidcConfiguration;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.authenticator.UserInfoOidcAuthenticator;

public class AuthPac4jModuleOidc
extends AuthPac4jModuleMultiClient {
    private static final Map<String, Map<String, String>> allSettings = AuthPac4jModuleOidc.getAuthSettings("auth.oidc.");
    private final Map<String, Function<Map<String, String>, Client<?, ?>>> providers = ImmutableMap.builder().put((Object)"google", this::setupGoogle).put((Object)"azuread", this::setupAzureAd).put((Object)"keycloak", this::setupKeycloak).build();

    public AuthPac4jModuleOidc(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    protected void configureClients() {
        this.addLocalClientsIfNotExclusive(allSettings);
        this.addCentralClients(allSettings, this.providers);
    }

    @Override
    protected Client<?, ?> setupGeneric(Map<String, String> settings, String providerName) {
        OidcClient client;
        String clientId = settings.get("client.id");
        String secret = settings.get("secret");
        String discoveryURI = settings.get("discovery.uri");
        boolean useNonce = settings.getOrDefault("use.nonce", "false").equals("true");
        String responseType = settings.get("response.type");
        String responseMode = settings.get("response.mode");
        String scope = settings.get("scope");
        String headerName = settings.get("header.name");
        String prefixHeader = settings.get("prefix.header");
        String name = settings.getOrDefault("name", providerName);
        String title = settings.getOrDefault("title", "OpenID Connect");
        String icon = settings.getOrDefault("icon", "img/signin/openid.svg");
        OidcConfiguration config = new OidcConfiguration();
        config.setClientId(clientId);
        config.setSecret(secret);
        config.setUseNonce(useNonce);
        if (StringUtils.notBlank((CharSequence)discoveryURI)) {
            config.setDiscoveryURI(discoveryURI);
        }
        if (StringUtils.notBlank((CharSequence)responseType)) {
            config.setResponseType(responseType);
        }
        if (StringUtils.notBlank((CharSequence)responseMode)) {
            config.setResponseMode(responseMode);
        }
        if (StringUtils.notBlank((CharSequence)scope)) {
            config.setScope(scope);
        }
        if (StringUtils.notBlank((CharSequence)headerName) && StringUtils.notBlank((CharSequence)prefixHeader)) {
            UserInfoOidcAuthenticator authenticator = new UserInfoOidcAuthenticator(config);
            client = new HeaderClient(headerName, prefixHeader.trim() + " ", (Authenticator)authenticator);
        } else {
            OidcClient oidcClient = new OidcClient(config);
            oidcClient.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
            client = oidcClient;
        }
        client.setName(name);
        AuthPac4jModuleOidc.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupGoogle(Map<String, String> settings) {
        String clientId = settings.get("client.id");
        String secret = settings.get("secret");
        String title = settings.getOrDefault("title", "Google");
        String icon = settings.getOrDefault("icon", "img/signin/google.svg");
        OidcConfiguration config = new OidcConfiguration();
        config.setClientId(clientId);
        config.setSecret(secret);
        GoogleOidcClient client = new GoogleOidcClient(config);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOidc.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupAzureAd(Map<String, String> settings) {
        String clientId = settings.get("client.id");
        String secret = settings.get("secret");
        String tenant = settings.get("tenant");
        String title = settings.getOrDefault("title", "Azure Active Directory");
        String icon = settings.getOrDefault("icon", "img/signin/microsoft.svg");
        AzureAdOidcConfiguration config = new AzureAdOidcConfiguration();
        config.setClientId(clientId);
        config.setSecret(secret);
        config.setTenant(tenant);
        AzureAdClient client = new AzureAdClient(config);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOidc.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    private Client<?, ?> setupKeycloak(Map<String, String> settings) {
        String clientId = settings.get("client.id");
        String secret = settings.get("secret");
        String realm = settings.get("realm");
        String baseUri = settings.get("base.uri");
        String title = settings.getOrDefault("title", "Keycloak");
        String icon = settings.getOrDefault("icon", "img/signin/keycloak.svg");
        KeycloakOidcConfiguration config = new KeycloakOidcConfiguration();
        config.setClientId(clientId);
        config.setSecret(secret);
        config.setRealm(realm);
        config.setBaseUri(baseUri);
        KeycloakOidcClient client = new KeycloakOidcClient(config);
        client.setUrlResolver((UrlResolver)new DefaultUrlResolver(true));
        AuthPac4jModuleOidc.setClientInfo(client.getName(), (Map<String, String>)ImmutableMap.of((Object)"title", (Object)title, (Object)"icon", (Object)icon));
        return client;
    }

    public static boolean isEnabled() {
        return !allSettings.isEmpty();
    }
}

