/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.pac4j.AuthPac4jModule;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.pac4j.core.client.Client;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;

public class AuthPac4jModuleSaml
extends AuthPac4jModule {
    private static final Map<String, String> authnRequestBindingTypes = ImmutableMap.of((Object)"SAML2_POST_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (Object)"SAML2_POST_SIMPLE_SIGN_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign", (Object)"SAML2_REDIRECT_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
    private static final Map<String, String> responseBindingTypes = ImmutableMap.of((Object)"SAML2_POST_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", (Object)"SAML2_ARTIFACT_BINDING_URI", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");

    public AuthPac4jModuleSaml(ServletContext servletContext) {
        super(servletContext);
        AuthPac4jModule.requireAbsCallbackUrl();
    }

    @Override
    protected void configureClients() {
        AppSettings settings = AppSettings.get();
        String keystorePath = settings.get("auth.saml.keystore.path");
        String keystorePassword = settings.get("auth.saml.keystore.password");
        String privateKeyPassword = settings.get("auth.saml.private.key.password");
        String identityProviderMetadataPath = settings.get("auth.saml.identity.provider.metadata.path");
        int maximumAuthenticationLifetime = settings.getInt("auth.saml.maximum.authentication.lifetime", -1);
        String serviceProviderEntityId = settings.get("auth.saml.service.provider.entity.id", null);
        String serviceProviderMetadataPath = settings.get("auth.saml.service.provider.metadata.path", null);
        boolean forceAuth = settings.getBoolean("auth.saml.force.auth", false);
        boolean passive = settings.getBoolean("auth.saml.passive", false);
        String authnRequestBindingType = settings.get("auth.saml.authn.request.binding.type", null);
        String responseBindingType = settings.get("auth.saml.response.binding.type", null);
        boolean useNameQualifier = settings.getBoolean("auth.saml.use.name.qualifier", false);
        int attributeConsumingServiceIndex = settings.getInt("auth.saml.attribute.consuming.service.index", -1);
        int assertionConsumerServiceIndex = settings.getInt("auth.saml.assertion.consumer.service.index", -1);
        List<String> blackListedSignatureSigningAlgorithms = settings.getList("auth.saml.blacklisted.signature.signing.algorithms");
        List<String> signatureAlgorithms = settings.getList("auth.saml.signature.algorithms");
        List<String> signatureReferenceDigestMethods = settings.getList("auth.saml.signature.reference.digest.methods");
        String signatureCanonicalizationAlgorithm = settings.get("auth.saml.signature.canonicalization.algorithm", null);
        boolean wantsAssertionsSigned = settings.getBoolean("auth.saml.wants.assertions.signed", false);
        boolean authnRequestSigned = settings.getBoolean("auth.saml.authn.request.signed", false);
        SAML2Configuration saml2Config = new SAML2Configuration(keystorePath, keystorePassword, privateKeyPassword, identityProviderMetadataPath);
        if (maximumAuthenticationLifetime >= 0) {
            saml2Config.setMaximumAuthenticationLifetime(maximumAuthenticationLifetime);
        }
        if (serviceProviderEntityId != null) {
            saml2Config.setServiceProviderEntityId(serviceProviderEntityId);
        }
        if (serviceProviderMetadataPath != null) {
            saml2Config.setServiceProviderMetadataPath(serviceProviderMetadataPath);
        }
        saml2Config.setForceAuth(forceAuth);
        saml2Config.setPassive(passive);
        if (authnRequestBindingType != null) {
            saml2Config.setAuthnRequestBindingType(authnRequestBindingTypes.getOrDefault(authnRequestBindingType, authnRequestBindingType));
        }
        if (responseBindingType != null) {
            saml2Config.setResponseBindingType(responseBindingTypes.getOrDefault(responseBindingType, responseBindingType));
        }
        saml2Config.setUseNameQualifier(useNameQualifier);
        if (attributeConsumingServiceIndex >= 0) {
            saml2Config.setAttributeConsumingServiceIndex(attributeConsumingServiceIndex);
        }
        if (assertionConsumerServiceIndex >= 0) {
            saml2Config.setAssertionConsumerServiceIndex(assertionConsumerServiceIndex);
        }
        if (!blackListedSignatureSigningAlgorithms.isEmpty()) {
            saml2Config.setBlackListedSignatureSigningAlgorithms(blackListedSignatureSigningAlgorithms);
        }
        if (!signatureAlgorithms.isEmpty()) {
            saml2Config.setSignatureAlgorithms(signatureAlgorithms);
        }
        if (!signatureReferenceDigestMethods.isEmpty()) {
            saml2Config.setSignatureReferenceDigestMethods(signatureReferenceDigestMethods);
        }
        if (signatureCanonicalizationAlgorithm != null) {
            saml2Config.setSignatureCanonicalizationAlgorithm(signatureCanonicalizationAlgorithm);
        }
        saml2Config.setWantsAssertionsSigned(wantsAssertionsSigned);
        saml2Config.setAuthnRequestSigned(authnRequestSigned);
        AxelorSAML2Client client = new AxelorSAML2Client(saml2Config);
        this.addCentralClient((Client<?, ?>)client);
    }

    public static boolean isEnabled() {
        AppSettings settings = AppSettings.get();
        return settings.get("auth.saml.keystore.path", null) != null;
    }

    private static class AxelorSAML2Client
    extends SAML2Client {
        public AxelorSAML2Client(SAML2Configuration configuration) {
            super(configuration);
            this.setName(((Object)((Object)this)).getClass().getSuperclass().getSimpleName());
        }

        protected void clientInit() {
            if (this.configuration.getServiceProviderEntityId() == null) {
                String serviceProviderEntityId = String.format("%s?client_name=%s", AuthPac4jModule.getCallbackUrl(), this.getName());
                this.configuration.setServiceProviderEntityId(serviceProviderEntityId);
            }
            this.configuration.setPostLogoutURL(AppSettings.get().getBaseURL());
            super.clientInit();
        }
    }
}

