/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.auth.db.repo.PermissionRepository;
import com.axelor.auth.db.repo.RoleRepository;
import com.axelor.auth.pac4j.AuthPac4jModuleCas;
import com.axelor.common.StringUtils;
import com.axelor.meta.db.MetaSelect;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.repo.MetaSelectRepository;
import com.google.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.pac4j.core.profile.CommonProfile;

@Singleton
public class AuthPac4jProfileService {
    @Inject
    protected GroupRepository groupRepo;
    @Inject
    protected RoleRepository roleRepo;
    @Inject
    protected PermissionRepository permissionRepo;
    @Inject
    protected MetaSelectRepository metaSelectRepo;
    public static final String GROUP_ATTRIBUTE = "group";
    private static final int DOWNLOAD_TIMEOUT = 5000;
    private static final int DOWNLOAD_CHUNK_SIZE = 32768;

    public String getCodeOrEmail(CommonProfile profile) {
        return Stream.of(profile.getUsername(), profile.getEmail(), profile.getId()).filter(StringUtils::notBlank).findFirst().orElseThrow(NullPointerException::new);
    }

    public String getName(CommonProfile profile) {
        if (AuthPac4jModuleCas.isEnabled()) {
            Optional<String> name = Optional.ofNullable(AppSettings.get().get("auth.cas.attrs.user.name", null)).map(arg_0 -> ((CommonProfile)profile).getAttribute(arg_0)).map(Object::toString).filter(StringUtils::notBlank);
            if (name.isPresent()) {
                return name.get();
            }
        }
        if (StringUtils.notBlank((CharSequence)profile.getDisplayName())) {
            return profile.getDisplayName();
        }
        return this.getCodeOrEmail(profile);
    }

    @Nullable
    public String getEmail(CommonProfile profile) {
        if (AuthPac4jModuleCas.isEnabled()) {
            Optional<String> email2 = Optional.ofNullable(AppSettings.get().get("auth.cas.attrs.user.email", null)).map(arg_0 -> ((CommonProfile)profile).getAttribute(arg_0)).map(Object::toString).filter(StringUtils::notBlank);
            if (email2.isPresent()) {
                return email2.get();
            }
        }
        return Stream.of(profile.getEmail(), profile.getId()).filter(StringUtils::notBlank).filter(email -> email.matches(".+\\@.+\\..+")).findFirst().orElse(null);
    }

    @Nullable
    public String getLanguage(CommonProfile profile) {
        Locale locale = profile.getLocale();
        if (locale != null) {
            String language;
            Set<String> languages = this.getLanguages();
            if (languages.contains(language = locale.toString())) {
                return language;
            }
            String shortLanguage = language.split("_")[0];
            if (languages.contains(shortLanguage)) {
                return shortLanguage;
            }
        }
        return null;
    }

    @Nullable
    public String getLanguage(CommonProfile profile, String defaultLanguage) {
        return Optional.ofNullable(this.getLanguage(profile)).orElse(defaultLanguage);
    }

    @Nullable
    public byte[] getImage(CommonProfile profile) throws IOException {
        URI uri = profile.getPictureUrl();
        return uri != null ? this.downloadUrl(uri.toURL()) : null;
    }

    @Nullable
    public Group getGroup(CommonProfile profile) {
        return Optional.ofNullable(profile.getAttribute(GROUP_ATTRIBUTE)).map(String::valueOf).map(this.groupRepo::findByCode).orElse(null);
    }

    @Nullable
    public Group getGroup(CommonProfile profile, String defaultGroupCode) {
        String groupCode = Optional.ofNullable(profile.getAttribute(GROUP_ATTRIBUTE)).map(String::valueOf).orElse(defaultGroupCode);
        return this.groupRepo.findByCode(groupCode);
    }

    public Set<Role> getRoles(CommonProfile profile) {
        return profile.getRoles().stream().map(this.roleRepo::findByName).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Permission> getPermissions(CommonProfile profile) {
        return profile.getPermissions().stream().map(this.permissionRepo::findByName).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected Set<String> getLanguages() {
        MetaSelect languageSelect = this.metaSelectRepo.findByName("select.language");
        if (languageSelect == null) {
            return Collections.emptySet();
        }
        return Optional.ofNullable(languageSelect.getItems()).orElse(Collections.emptyList()).stream().map(MetaSelectItem::getValue).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected byte[] downloadUrl(URL url) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        URLConnection conn = url.openConnection();
        byte[] chunk = new byte[32768];
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        try (InputStream is = conn.getInputStream();){
            int bytesRead;
            while ((bytesRead = is.read(chunk)) > 0) {
                os.write(chunk, 0, bytesRead);
            }
        }
        return os.toByteArray();
    }
}

