/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.UserAuthenticationInfo;
import com.axelor.auth.db.User;
import com.axelor.auth.pac4j.AuthPac4jUserService;
import com.axelor.event.Event;
import com.axelor.events.PreLogin;
import io.buji.pac4j.realm.Pac4jRealm;
import io.buji.pac4j.token.Pac4jToken;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.pac4j.core.profile.CommonProfile;

public class AuthPac4jRealm
extends Pac4jRealm {
    @Inject
    private Event<PreLogin> preLogin;
    @Inject
    private AuthPac4jUserService userService;

    public AuthPac4jRealm() {
        AppSettings settings = AppSettings.get();
        this.setPrincipalNameAttribute(settings.get("auth.user.principal.attribute", "email"));
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) {
        CommonProfile profile;
        User user;
        this.preLogin.fire(new PreLogin(authenticationToken));
        Pac4jToken token = (Pac4jToken)authenticationToken;
        List profiles = token.getProfiles();
        Optional profileOpt = (Optional)token.getPrincipal();
        if (profileOpt.isPresent() && (user = this.userService.getUser(profile = (CommonProfile)profileOpt.get())) != null && AuthUtils.isActive(user)) {
            profile.clearSensitiveData();
            profile.setRemembered(true);
            return new UserAuthenticationInfo(user.getCode(), profiles.hashCode(), this.getName(), user);
        }
        return super.doGetAuthenticationInfo((AuthenticationToken)token);
    }
}

