/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.pac4j;

import com.axelor.app.AppSettings;
import com.axelor.auth.pac4j.AuthPac4jModuleLocal;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.FormatDnResolver;
import org.ldaptive.auth.PooledBindAuthenticationHandler;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.sasl.CramMd5Config;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.ExternalConfig;
import org.ldaptive.sasl.GssApiConfig;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.KeyStoreCredentialConfig;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509CredentialConfig;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.converter.AbstractAttributeConverter;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.ldap.profile.LdapProfile;
import org.pac4j.ldap.profile.service.LdapProfileService;

@Singleton
public class AxelorLdapProfileService
extends LdapProfileService
implements AuthPac4jModuleLocal.AxelorAuthenticator {
    private final String groupsDn;
    private final String groupFilter;

    @Inject
    public AxelorLdapProfileService() {
        this(AppSettings.get().getProperties());
    }

    public AxelorLdapProfileService(Properties properties) {
        SearchDnResolver dnResolver;
        X509CredentialConfig credentialConfig;
        String ldapUrl = properties.getProperty("auth.ldap.server.url");
        String usersDn = properties.getProperty("auth.ldap.user.base");
        String idAttribute = properties.getProperty("auth.ldap.user.id.attribute", "uid");
        String userFilter = Optional.ofNullable(properties.getProperty("auth.ldap.user.filter")).map(property -> property.replace("{0}", "{user}")).orElse(null);
        String systemDn = properties.getProperty("auth.ldap.system.user");
        String systemPassword = properties.getProperty("auth.ldap.system.password");
        String authenticationType = properties.getProperty("auth.ldap.auth.type");
        boolean useSSL = Boolean.parseBoolean(properties.getProperty("auth.ldap.use.ssl"));
        boolean useStartTLS = Boolean.parseBoolean(properties.getProperty("auth.ldap.use.starttls"));
        String trustStore = properties.getProperty("auth.ldap.credential.trust.store");
        String keyStore = properties.getProperty("auth.ldap.credential.key.store");
        String trustCertificates = properties.getProperty("auth.ldap.credential.trust.certificates");
        Duration connectTimeout = Optional.ofNullable(properties.getProperty("auth.ldap.connect.timeout")).filter(StringUtils::notBlank).map(Long::parseLong).map(Duration::ofSeconds).orElse(null);
        Duration responseTimeout = Optional.ofNullable(properties.getProperty("auth.ldap.response.timeout")).filter(StringUtils::notBlank).map(Long::parseLong).map(Duration::ofSeconds).orElse(null);
        SaslConfig saslConfig = this.getSaslConfig(authenticationType);
        if (StringUtils.notBlank((CharSequence)trustStore) || StringUtils.notBlank((CharSequence)keyStore)) {
            String storePassword = properties.getProperty("auth.ldap.credential.store.password");
            String storeType = properties.getProperty("auth.ldap.credential.store.type");
            String[] storeAliases = Optional.ofNullable(properties.getProperty("auth.ldap.credential.store.aliases")).map(storeAliasesProperty -> storeAliasesProperty.split("\\s*,\\s*")).orElse(null);
            KeyStoreCredentialConfig keyStoreCredentialConfig = new KeyStoreCredentialConfig();
            if (StringUtils.notBlank((CharSequence)trustStore)) {
                keyStoreCredentialConfig.setTrustStore(trustStore);
                keyStoreCredentialConfig.setTrustStorePassword(storePassword);
                keyStoreCredentialConfig.setTrustStoreType(storeType);
                keyStoreCredentialConfig.setTrustStoreAliases(storeAliases);
            } else {
                keyStoreCredentialConfig.setKeyStore(keyStore);
                keyStoreCredentialConfig.setKeyStorePassword(storePassword);
                keyStoreCredentialConfig.setKeyStoreType(storeType);
                keyStoreCredentialConfig.setKeyStoreAliases(storeAliases);
            }
            credentialConfig = keyStoreCredentialConfig;
        } else if (StringUtils.notBlank((CharSequence)trustCertificates)) {
            String authenticationCertificate = properties.getProperty("auth.ldap.credential.authentication.certificate");
            String authenticationKey = properties.getProperty("auth.ldap.credential.authentication.key");
            X509CredentialConfig x509CredentialConfig = new X509CredentialConfig();
            x509CredentialConfig.setTrustCertificates(trustCertificates);
            x509CredentialConfig.setAuthenticationCertificate(authenticationCertificate);
            x509CredentialConfig.setAuthenticationKey(authenticationKey);
            credentialConfig = x509CredentialConfig;
        } else {
            credentialConfig = null;
        }
        this.groupsDn = properties.getProperty("auth.ldap.group.base");
        this.groupFilter = properties.getProperty("auth.ldap.group.filter");
        SslConfig sslConfig = credentialConfig != null ? new SslConfig(credentialConfig) : null;
        ConnectionConfig connectionConfig = new ConnectionConfig(ldapUrl);
        if (useSSL) {
            connectionConfig.setUseSSL(useSSL);
        }
        if (useStartTLS) {
            connectionConfig.setUseStartTLS(useStartTLS);
        }
        if (StringUtils.notBlank((CharSequence)systemDn)) {
            BindConnectionInitializer initializer = new BindConnectionInitializer(systemDn, new Credential(systemPassword));
            if (saslConfig != null) {
                initializer.setBindSaslConfig(saslConfig);
            }
            connectionConfig.setConnectionInitializer((ConnectionInitializer)initializer);
        }
        if (sslConfig != null) {
            connectionConfig.setSslConfig(sslConfig);
        }
        if (connectTimeout != null) {
            connectionConfig.setConnectTimeout(connectTimeout);
        }
        if (responseTimeout != null) {
            connectionConfig.setResponseTimeout(responseTimeout);
        }
        DefaultConnectionFactory connectionFactory = new DefaultConnectionFactory(connectionConfig);
        BlockingConnectionPool connectionPool = new BlockingConnectionPool(connectionFactory);
        connectionPool.initialize();
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory((ConnectionPool)connectionPool);
        PooledBindAuthenticationHandler handler = new PooledBindAuthenticationHandler(pooledConnectionFactory);
        if (StringUtils.notBlank((CharSequence)userFilter)) {
            SearchDnResolver searchDnResolver = new SearchDnResolver((ConnectionFactory)connectionFactory);
            searchDnResolver.setBaseDn(usersDn);
            searchDnResolver.setUserFilter(userFilter);
            dnResolver = searchDnResolver;
        } else {
            dnResolver = new FormatDnResolver(String.format("%s=%%s,%s", idAttribute, usersDn));
        }
        Authenticator ldapAuthenticator = new Authenticator((DnResolver)dnResolver, (AuthenticationHandler)handler);
        String attributes = AxelorLdapProfileDefinition.getAttributes(idAttribute);
        this.setConnectionFactory((ConnectionFactory)connectionFactory);
        this.setLdapAuthenticator(ldapAuthenticator);
        this.setAttributes(attributes);
        this.setUsersDn(usersDn);
        this.setIdAttribute(idAttribute);
        this.setUsernameAttribute("uid");
        this.setPasswordAttribute("userPassword");
        this.setProfileDefinition((ProfileDefinition)new AxelorLdapProfileDefinition());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public LdapEntry searchGroup(String groupName) {
        String filter = String.format("(%s=%s)", "cn", groupName);
        try (Connection conn = this.getConnectionFactory().getConnection();){
            conn.open();
            SearchRequest request = new SearchRequest(this.groupsDn, filter, (String[])AxelorLdapGroupDefinition.ATTRIBUTES.stream().toArray(String[]::new));
            SearchOperation search = new SearchOperation(conn);
            SearchResult result = (SearchResult)search.execute((Request)request).getResult();
            LdapEntry ldapEntry = result.getEntry();
            return ldapEntry;
        }
        catch (LdapException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected SaslConfig getSaslConfig(String authenticationType) {
        String mechanismName;
        switch (mechanismName = StringUtils.isBlank((CharSequence)authenticationType) ? "SIMPLE" : authenticationType.toUpperCase().replace('-', '_')) {
            case "NONE": 
            case "SIMPLE": {
                return null;
            }
            case "CRAM_MD5": {
                return new CramMd5Config();
            }
            case "DIGEST_MD5": {
                return new DigestMd5Config();
            }
            case "EXTERNAL": {
                return new ExternalConfig();
            }
            case "GSSAPI": {
                return new GssApiConfig();
            }
        }
        SaslConfig saslConfig = new SaslConfig();
        saslConfig.setMechanism(Mechanism.valueOf((String)mechanismName));
        return saslConfig;
    }

    protected LdapProfile convertAttributesToProfile(List<Map<String, Object>> listStorageAttributes, String username) {
        LdapProfile profile = (LdapProfile)super.convertAttributesToProfile(listStorageAttributes, username);
        this.setGroup(profile);
        return profile;
    }

    protected void setGroup(LdapProfile profile) {
        block20: {
            if (StringUtils.isBlank((CharSequence)this.groupsDn)) {
                return;
            }
            try (Connection conn = this.getConnectionFactory().getConnection();){
                conn.open();
                if (StringUtils.notBlank((CharSequence)this.groupFilter)) {
                    this.setGroup(profile, MessageFormat.format(this.groupFilter, profile.getId()), conn);
                    return;
                }
                Integer groupId = (Integer)profile.getAttribute("gidNumber");
                if (groupId != null && this.setGroup(profile, String.format("(%s=%d)", "gidNumber", groupId), conn) != null) break block20;
                String entryId = this.getEntryId(this.convertProfileAndPasswordToAttributes((CommonProfile)profile, null));
                for (String memberAttribute : ImmutableList.of((Object)"uniqueMember", (Object)"member")) {
                    if (this.setGroup(profile, String.format("(%s=%s)", memberAttribute, entryId), conn) == null) continue;
                    break;
                }
            }
            catch (LdapException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Nullable
    protected String setGroup(LdapProfile profile, String filter, Connection conn) throws LdapException {
        SearchOperation search = new SearchOperation(conn);
        SearchRequest request = new SearchRequest(this.groupsDn, filter, new String[]{"cn"});
        SearchResult result = (SearchResult)search.execute((Request)request).getResult();
        LdapEntry entry = result.getEntry();
        if (entry != null) {
            String groupName = entry.getAttribute("cn").getStringValue();
            profile.addAttribute("group", (Object)groupName);
            return groupName;
        }
        return null;
    }

    protected List<LdapAttribute> getLdapAttributes(Map<String, Object> attributes) {
        List ldapAttributes = super.getLdapAttributes(attributes);
        ArrayList<LdapAttribute> binaryLdapAttributes = new ArrayList<LdapAttribute>();
        Iterator it = ldapAttributes.iterator();
        while (it.hasNext()) {
            LdapAttribute ldapAttribute = (LdapAttribute)it.next();
            String name = ldapAttribute.getName();
            Object value = attributes.get(name);
            if (!(value instanceof byte[])) continue;
            it.remove();
            binaryLdapAttributes.add(new LdapAttribute(name, (byte[][])new byte[][]{(byte[])value}));
        }
        ldapAttributes.addAll(binaryLdapAttributes);
        return ldapAttributes;
    }

    public static class ByteArrayConverter
    extends AbstractAttributeConverter<byte[]> {
        public static final ByteArrayConverter INSTANCE = new ByteArrayConverter();

        protected ByteArrayConverter() {
            super(byte[].class);
        }

        protected byte[] internalConvert(Object attribute) {
            return ObjectUtils.isEmpty((Object)attribute) ? null : Base64.getDecoder().decode(attribute.toString());
        }
    }

    public static class AxelorLdapProfile
    extends LdapProfile {
        private transient Path picturePath;

        public String getUsername() {
            return this.getId();
        }

        public String getEmail() {
            return (String)this.getAttribute("mail");
        }

        public String getDisplayName() {
            return (String)this.getAttribute("cn");
        }

        public String getFirstName() {
            return (String)this.getAttribute("givenName");
        }

        public String getFamilyName() {
            return (String)this.getAttribute("sn");
        }

        public Locale getLocale() {
            return (Locale)this.getAttribute("preferredLanguage");
        }

        public URI getPictureUrl() {
            if (this.picturePath != null && this.picturePath.toFile().exists()) {
                return this.picturePath.toUri();
            }
            byte[] jpegPhoto = (byte[])this.getAttribute("jpegPhoto");
            if (ObjectUtils.notEmpty((Object)jpegPhoto)) {
                try {
                    this.picturePath = Files.createTempFile(null, ".jpg", new FileAttribute[0]);
                    Files.write(this.picturePath, jpegPhoto, new OpenOption[0]);
                    return this.picturePath.toUri();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return null;
        }
    }

    public static class AxelorLdapProfileDefinition
    extends CommonProfileDefinition<LdapProfile> {
        public static final String USERNAME = "uid";
        public static final String DISPLAY_NAME = "cn";
        public static final String EMAIL = "mail";
        public static final String FIRST_NAME = "givenName";
        public static final String FAMILY_NAME = "sn";
        public static final String LOCALE = "preferredLanguage";
        public static final String PICTURE_JPEG = "jpegPhoto";
        public static final String PASSWORD = "userPassword";
        public static final List<String> ATTRIBUTES = ImmutableList.of((Object)"uid", (Object)"mail", (Object)"cn", (Object)"givenName", (Object)"sn", (Object)"preferredLanguage", (Object)"jpegPhoto", (Object)"gidNumber");

        public AxelorLdapProfileDefinition() {
            super(x -> new AxelorLdapProfile());
            Stream.of(USERNAME, EMAIL, DISPLAY_NAME, FIRST_NAME, FAMILY_NAME).forEach(attribute -> this.primary((String)attribute, (AttributeConverter)Converters.STRING));
            this.primary(LOCALE, (AttributeConverter)Converters.LOCALE);
            this.primary("gidNumber", (AttributeConverter)Converters.INTEGER);
            this.primary(PICTURE_JPEG, (AttributeConverter)ByteArrayConverter.INSTANCE);
        }

        public static String getAttributes(String idAttribute) {
            return ATTRIBUTES.stream().filter(attribute -> !attribute.equals(idAttribute)).collect(Collectors.joining(","));
        }
    }

    public static class AxelorLdapGroupDefinition {
        public static final String NAME = "cn";
        public static final String ID = "gidNumber";
        public static final String OBJECT_CLASS = "objectClass";
        public static final String UNIQUE_MEMBER = "uniqueMember";
        public static final String MEMBER = "member";
        public static final List<String> ATTRIBUTES = ImmutableList.of((Object)"cn", (Object)"gidNumber", (Object)"objectClass", (Object)"uniqueMember", (Object)"member");
    }
}

