/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.mapper.types.JavaTimeAdapter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.LocalDateTime;

public class AuditHelper {
    private static final String CREATED_ON = "createdOn";
    private static final String CREATED_BY = "createdBy";
    private static final String UPDATED_ON = "updatedOn";
    private static final String UPDATED_BY = "updatedBy";
    private static final String SET_CREATED_ON = "setCreatedOn";
    private static final String SET_CREATED_BY = "setCreatedBy";
    private static final String SET_UPDATED_ON = "setUpdatedOn";
    private static final String SET_UPDATED_BY = "setUpdatedBy";
    private static Method createdOn;
    private static Method createdBy;
    private static Method updatedOn;
    private static Method updatedBy;
    private static JavaTimeAdapter adapter;

    private AuditHelper() {
    }

    private static void init() {
        adapter = new JavaTimeAdapter();
        try {
            createdOn = AuditableModel.class.getDeclaredMethod(SET_CREATED_ON, LocalDateTime.class);
            createdBy = AuditableModel.class.getDeclaredMethod(SET_CREATED_BY, User.class);
            updatedOn = AuditableModel.class.getDeclaredMethod(SET_UPDATED_ON, LocalDateTime.class);
            updatedBy = AuditableModel.class.getDeclaredMethod(SET_UPDATED_BY, User.class);
            createdOn.setAccessible(true);
            createdBy.setAccessible(true);
            updatedOn.setAccessible(true);
            updatedBy.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object adapt(Object value) {
        return adapter.adapt(value, LocalDateTime.class, (Type)((Object)LocalDateTime.class), null);
    }

    private static Object invoke(Object bean, Method method, Object value) {
        try {
            return method.invoke(bean, value);
        }
        catch (Exception exception) {
            return value;
        }
    }

    public static boolean update(Object bean, String field, Object value) {
        if (bean == null || !AuditableModel.class.isInstance(bean)) {
            return false;
        }
        if (adapter == null) {
            AuditHelper.init();
        }
        switch (field) {
            case "createdBy": {
                AuditHelper.invoke(bean, createdBy, value);
                break;
            }
            case "updatedBy": {
                AuditHelper.invoke(bean, updatedBy, value);
                break;
            }
            case "createdOn": {
                AuditHelper.invoke(bean, createdOn, AuditHelper.adapt(value));
                break;
            }
            case "updatedOn": {
                AuditHelper.invoke(bean, updatedOn, AuditHelper.adapt(value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

