/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data;

import com.axelor.db.JpaRepository;
import com.axelor.db.JpaScanner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataScriptHelper {
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final int DEFAULT_EXPIRE_TIME = 10;
    private static final Logger log = LoggerFactory.getLogger(DataScriptHelper.class);
    private static final CompilerConfiguration config = new CompilerConfiguration();
    private static final CompilerConfiguration configIndy = new CompilerConfiguration();
    private boolean indy = true;
    private int cacheSize = 100;
    private int expireTime = 10;
    private LoadingCache<String, Script> cache = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).expireAfterAccess((long)this.expireTime, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Script>(){

        public Script load(String expr) throws Exception {
            CompilerConfiguration cfg = DataScriptHelper.this.indy ? configIndy : config;
            return new GroovyShell(JpaScanner.getClassLoader(), new Binding(), cfg).parse(expr);
        }
    });

    public DataScriptHelper(int cacheSize, int expireTime, boolean indy) {
        this.cacheSize = cacheSize;
        this.expireTime = expireTime;
        this.indy = indy;
    }

    public synchronized Object eval(String expression, Map<String, Object> variables) {
        return this.eval(expression, new Binding(variables){

            public Object getVariable(String name) {
                try {
                    return super.getVariable(name);
                }
                catch (MissingPropertyException e) {
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String expression, Binding binding) {
        Script script;
        try {
            script = (Script)this.cache.get((Object)expression);
        }
        catch (ExecutionException e) {
            log.warn("Invalid script: {}", (Object)expression);
            return null;
        }
        try {
            script.setBinding(binding);
            Object object = script.run();
            return object;
        }
        finally {
            script.setBinding(null);
        }
    }

    static {
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStaticImport("__repo__", JpaRepository.class.getName(), "of");
        configIndy.getOptimizationOptions().put("indy", true);
        configIndy.getOptimizationOptions().put("int", false);
        configIndy.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        config.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
    }
}

