/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.adapter;

import com.axelor.data.adapter.Adapter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class JavaTimeAdapter
extends Adapter {
    protected String DEFAULT_FORMAT = "yyyy-MM-ddTHH:mm:ss";

    @Override
    public Object adapt(Object value, Map<String, Object> context) {
        if (value == null || !(value instanceof String)) {
            return value;
        }
        String type = this.get("type", null);
        String text = (String)value;
        String format = this.get("format", this.DEFAULT_FORMAT);
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(format);
        switch (type) {
            case "LocalDate": {
                return fmt.parse((CharSequence)text, LocalDate::from);
            }
            case "LocalTime": {
                return fmt.parse((CharSequence)text, LocalTime::from);
            }
            case "LocalDateTime": {
                return fmt.parse((CharSequence)text, LocalDateTime::from);
            }
        }
        return fmt.parseBest((String)value, ZonedDateTime::from, LocalDateTime::from);
    }
}

