/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.csv;

import com.axelor.data.DataScriptHelper;
import com.axelor.inject.Beans;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.InvokerHelper;

@XStreamAlias(value="bind")
public class CSVBind {
    public static Pattern pattern = Pattern.compile("^(call|eval):\\s*(.*)");
    @XStreamAsAttribute
    private String column;
    @XStreamAlias(value="to")
    @XStreamAsAttribute
    private String field;
    @XStreamAsAttribute
    private String type;
    @XStreamAsAttribute
    private String search;
    @XStreamAsAttribute
    private boolean update;
    @XStreamAlias(value="eval")
    @XStreamAsAttribute
    private String expression;
    @XStreamAlias(value="if")
    @XStreamAsAttribute
    private String condition;
    @XStreamAlias(value="if-empty")
    @XStreamAsAttribute
    private Boolean conditionEmpty;
    @XStreamImplicit(itemFieldName="bind")
    private List<CSVBind> bindings;
    @XStreamAsAttribute
    private String adapter;
    private static DataScriptHelper helper = new DataScriptHelper(100, 10, false);

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public Boolean getConditionEmpty() {
        return this.conditionEmpty;
    }

    public void setConditionEmpty(Boolean conditionEmpty) {
        this.conditionEmpty = conditionEmpty;
    }

    public List<CSVBind> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<CSVBind> bindings) {
        this.bindings = bindings;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    public static CSVBind getBinding(String column, final String field, Set<String> cols) {
        CSVBind cb = new CSVBind();
        cb.field = field;
        cb.column = column;
        if (cols == null || cols.isEmpty()) {
            if (cb.column == null) {
                cb.column = field;
            }
            return cb;
        }
        for (String col : cols) {
            if (cb.bindings == null) {
                cb.bindings = Lists.newArrayList();
            }
            cb.bindings.add(CSVBind.getBinding(field + "." + col, col, null));
        }
        cb.update = true;
        cb.search = Joiner.on((String)" AND ").join((Iterable)Collections2.transform(cols, (Function)new Function<String, String>(){

            public String apply(String input) {
                return String.format("self.%s = :%s_%s_", input, field, input);
            }
        }));
        return cb;
    }

    public Object evaluate(Map<String, Object> context) {
        if (Strings.isNullOrEmpty((String)this.expression)) {
            return this.handleGroovy(context);
        }
        String kind = null;
        String expr = this.expression;
        Matcher matcher = pattern.matcher(this.expression);
        if (!matcher.matches()) {
            return this.handleGroovy(context);
        }
        kind = matcher.group(1);
        expr = matcher.group(2);
        if ("call".equals(kind)) {
            return this.handleCall(context, expr);
        }
        return this.handleGroovy(context);
    }

    private Object handleGroovy(Map<String, Object> context) {
        if (Strings.isNullOrEmpty((String)this.expression)) {
            return context.get(this.column);
        }
        return helper.eval(this.expression, context);
    }

    public boolean validate(Map<String, Object> context) {
        if (Strings.isNullOrEmpty((String)this.condition)) {
            return true;
        }
        String expr = this.condition + " ? true : false";
        return (Boolean)helper.eval(expr, context);
    }

    private Object handleCall(Map<String, Object> context, String expr) {
        if (Strings.isNullOrEmpty((String)expr)) {
            return null;
        }
        try {
            String className = expr.split("\\:")[0];
            String method = expr.split("\\:")[1];
            Class<?> klass = Class.forName(className);
            Object object = Beans.get(klass);
            Pattern p = Pattern.compile("(\\w+)\\((.*?)\\)");
            Matcher m = p.matcher(method);
            if (!m.matches()) {
                return null;
            }
            String methodName = m.group(1);
            String params = "[" + m.group(2) + "] as Object[]";
            Object[] arguments = (Object[])helper.eval(params, context);
            return InvokerHelper.invokeMethod(object, (String)methodName, (Object)arguments);
        }
        catch (Exception e) {
            System.err.println("EEE: " + e);
            return null;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", (Object)this.column).add("field", (Object)this.field).add("type", (Object)this.type).add("bindings", this.bindings).omitNullValues().toString();
    }
}

