/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.csv;

import com.axelor.common.VersionUtils;
import com.axelor.data.XStreamUtils;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.csv.CSVInput;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.File;
import java.util.List;

@XStreamAlias(value="csv-inputs")
public class CSVConfig {
    public static final String NAMESPACE = "http://axelor.com/xml/ns/data-import";
    public static final String VERSION = VersionUtils.getVersion().feature;
    @XStreamImplicit(itemFieldName="input")
    private List<CSVInput> inputs = Lists.newArrayList();
    @XStreamImplicit(itemFieldName="adapter")
    private List<DataAdapter> adapters = Lists.newArrayList();

    public List<CSVInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<CSVInput> inputs) {
        this.inputs = inputs;
    }

    public List<DataAdapter> getAdapters() {
        if (this.adapters == null) {
            this.adapters = Lists.newArrayList();
        }
        return this.adapters;
    }

    public static CSVConfig parse(File input) {
        XStream stream = XStreamUtils.createXStream();
        stream.processAnnotations(CSVConfig.class);
        return (CSVConfig)stream.fromXML(input);
    }
}

