/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.xml;

import com.axelor.data.xml.XMLBinder;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.DomWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ElementConverter
implements Converter {
    private XMLBinder binder;

    public ElementConverter(XMLBinder binder) {
        this.binder = binder;
    }

    public boolean canConvert(Class type) {
        return Document.class.isAssignableFrom(type) || Element.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (Document.class.isAssignableFrom(context.getRequiredType())) {
            String last = null;
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                Document node = (Document)context.convertAnother((Object)reader, Element.class);
                if (last != null && !last.equals(node.getFirstChild().getNodeName())) {
                    this.binder.finish();
                    last = node.getFirstChild().getNodeName();
                }
                if (last == null) {
                    last = node.getFirstChild().getNodeName();
                }
                reader.moveUp();
                this.binder.bind(node);
            }
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ConversionException("Cannot instantiate " + Document.class.getName(), (Throwable)e);
        }
        Document document = builder.newDocument();
        DomWriter writer = new DomWriter(document, (NameCoder)new NoNameCoder());
        ElementConverter.copy(reader, (HierarchicalStreamWriter)writer);
        return document;
    }

    private static void copy(HierarchicalStreamReader reader, HierarchicalStreamWriter writer) {
        writer.startNode(reader.getNodeName());
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = reader.getAttributeName(i);
            String attributeValue = reader.getAttribute(i);
            writer.addAttribute(attributeName, attributeValue);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ElementConverter.copy(reader, writer);
            reader.moveUp();
        }
        String value = reader.getValue();
        if (value != null && value.trim().length() > 0) {
            writer.setValue(value);
        }
        writer.endNode();
    }
}

