/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.xml;

import com.axelor.data.DataScriptHelper;
import com.axelor.data.ImportException;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.InvokerHelper;

@XStreamAlias(value="bind")
public class XMLBind {
    @XStreamAsAttribute
    private String node;
    @XStreamAlias(value="to")
    @XStreamAsAttribute
    private String field;
    @XStreamAsAttribute
    private String alias;
    @XStreamAlias(value="type")
    @XStreamAsAttribute
    private String typeName;
    @XStreamAsAttribute
    private String search;
    @XStreamAsAttribute
    private Boolean update;
    @XStreamAsAttribute
    private Boolean create;
    @XStreamAlias(value="eval")
    @XStreamAsAttribute
    private String expression;
    @XStreamAlias(value="if")
    @XStreamAsAttribute
    private String condition;
    @XStreamAlias(value="if-empty")
    @XStreamAsAttribute
    private Boolean conditionEmpty;
    @XStreamAlias(value="call")
    @XStreamAsAttribute
    private String callable;
    @XStreamAsAttribute
    private String adapter;
    @XStreamImplicit(itemFieldName="bind")
    private List<XMLBind> bindings;
    private Set<String> multiples;
    private Object callObject;
    private Method callMethod;
    public static Pattern pattern = Pattern.compile("^(call|eval):\\s*(.*)");
    private static DataScriptHelper helper = new DataScriptHelper(100, 10, false);

    public String getNode() {
        return this.node;
    }

    public String getField() {
        return this.field;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAliasOrName() {
        if (this.alias == null || "".equals(this.alias.trim())) {
            return this.node;
        }
        return this.alias;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Class<?> getType() {
        try {
            return Class.forName(this.typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String getSearch() {
        return this.search;
    }

    public Boolean getUpdate() {
        return this.update;
    }

    public Boolean getCreate() {
        return this.create;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getCondition() {
        return this.condition;
    }

    public Boolean getConditionEmpty() {
        return this.conditionEmpty;
    }

    public String getCallable() {
        return this.callable;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public List<XMLBind> getBindings() {
        return this.bindings;
    }

    public boolean isMultiple(XMLBind bind) {
        if (this.multiples == null) {
            this.multiples = Sets.newHashSet();
            HashSet found = Sets.newHashSet();
            for (XMLBind b : this.bindings) {
                if (found.contains(b.getNode())) {
                    this.multiples.add(b.getNode());
                }
                found.add(b.getNode());
            }
        }
        return this.multiples.contains(bind.getNode());
    }

    public <T> T call(T object, Map<String, Object> context) throws Exception {
        if (Strings.isNullOrEmpty((String)this.callable)) {
            return object;
        }
        if (this.callObject == null) {
            String className = this.callable.split("\\:")[0];
            String method = this.callable.split("\\:")[1];
            Class<?> klass = Class.forName(className);
            this.callMethod = klass.getMethod(method, Object.class, Map.class);
            this.callObject = Beans.get(klass);
        }
        try {
            return (T)this.callMethod.invoke(this.callObject, object, context);
        }
        catch (Exception e) {
            System.err.println("EEE: " + e);
            throw new ImportException(e);
        }
    }

    public Object evaluate(Map<String, Object> context) {
        if (Strings.isNullOrEmpty((String)this.expression)) {
            return this.handleGroovy(context);
        }
        String kind = null;
        String expr = this.expression;
        Matcher matcher = pattern.matcher(this.expression);
        if (!matcher.matches()) {
            return this.handleGroovy(context);
        }
        kind = matcher.group(1);
        expr = matcher.group(2);
        if ("call".equals(kind)) {
            return this.handleCall(context, expr);
        }
        return this.handleGroovy(context);
    }

    private Object handleGroovy(Map<String, Object> context) {
        if (Strings.isNullOrEmpty((String)this.expression)) {
            return context.get(this.getAliasOrName());
        }
        return helper.eval(this.expression, context);
    }

    public boolean validate(Map<String, Object> context) {
        if (Strings.isNullOrEmpty((String)this.condition)) {
            return true;
        }
        String expr = this.condition + " ? true : false";
        return (Boolean)helper.eval(expr, context);
    }

    private Object handleCall(Map<String, Object> context, String expr) {
        if (Strings.isNullOrEmpty((String)expr)) {
            return null;
        }
        try {
            String className = expr.split("\\:")[0];
            String method = expr.split("\\:")[1];
            Class<?> klass = Class.forName(className);
            Object object = Beans.get(klass);
            Pattern p = Pattern.compile("(\\w+)\\((.*?)\\)");
            Matcher m = p.matcher(method);
            if (!m.matches()) {
                return null;
            }
            String methodName = m.group(1);
            String params = "[" + m.group(2) + "] as Object[]";
            Object[] arguments = (Object[])helper.eval(params, context);
            return InvokerHelper.invokeMethod(object, (String)methodName, (Object)arguments);
        }
        catch (Exception e) {
            System.err.println("EEE: " + e);
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<bind");
        if (this.node != null) {
            sb.append(" node='").append(this.node).append("'");
        }
        if (this.field != null) {
            sb.append(" to=='").append(this.field).append("'");
        }
        if (this.typeName != null) {
            sb.append(" type='").append(this.typeName).append("'");
        }
        if (this.alias != null) {
            sb.append(" alias='").append(this.alias).append("'");
        }
        return sb.append(" ... >").toString();
    }
}

