/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.data.xml;

import com.axelor.data.AuditHelper;
import com.axelor.data.adapter.DataAdapter;
import com.axelor.data.xml.XMLBind;
import com.axelor.data.xml.XMLInput;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.mapper.PropertyType;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLBinder {
    private static final Logger LOG = LoggerFactory.getLogger(XMLBinder.class);
    private XMLInput input;
    private Map<String, Object> context;
    private boolean newBean;
    private Map<String, DataAdapter> adapters = new HashMap<String, DataAdapter>();
    private Class<?> lastClass = null;
    private XPath xpath = null;

    public XMLBinder(XMLInput input, Map<String, Object> context) {
        this.input = input;
        this.context = context;
    }

    public void registerAdapter(DataAdapter adapter) {
        this.adapters.put(adapter.getName(), adapter);
    }

    protected abstract void handle(Object var1, XMLBind var2, Map<String, Object> var3);

    protected abstract void finish();

    public void bind(Document element) {
        for (XMLBind binding : this.input.getBindings()) {
            LOG.debug("binding: " + binding);
            List<Node> nodes = this.find(element, binding, "/");
            for (Node node : nodes) {
                if (this.lastClass != binding.getType()) {
                    this.lastClass = binding.getType();
                    JPA.flush();
                }
                LOG.trace("element: <{} ...>", (Object)node.getNodeName());
                Map<String, Object> map = this.toMap(node, binding);
                Object bean = this.bind(binding, binding.getType(), map);
                LOG.trace("bean created: {}", bean);
                this.handle(bean, binding, this.toContext(map));
                LOG.trace("bean saved: {}", bean);
            }
        }
    }

    private Object bind(XMLBind binding, Class<?> type, Map<String, Object> values) {
        boolean isNull;
        if (type == null || values == null || values.size() == 0) {
            return null;
        }
        Object bean = null;
        Map<String, Object> ctx = this.toContext(values);
        LOG.trace("context: " + ctx);
        if (binding.getSearch() != null) {
            LOG.trace("search: " + binding.getSearch());
            bean = JPA.all(type).filter(binding.getSearch()).bind(ctx).fetchOne();
            LOG.trace("search found: " + bean);
            if (bean != null && binding.getUpdate() != Boolean.TRUE) {
                LOG.trace("search no update");
                return bean;
            }
            if (bean == null && binding.getCreate() == Boolean.FALSE) {
                LOG.trace("search no create");
                return null;
            }
        }
        Mapper mapper = Mapper.of(type);
        List<XMLBind> bindings = binding.getBindings();
        this.newBean = isNull = bean == null;
        if (bindings == null) {
            return bean;
        }
        if (isNull) {
            bean = this.newInstance(type);
        }
        LOG.trace("populate: " + type);
        for (XMLBind bind : bindings) {
            String name;
            LOG.trace("binding: " + bind);
            String field = bind.getField();
            String string = name = bind.getAlias() != null ? bind.getAlias() : field;
            Property property = mapper.getProperty(field);
            if (property == null || property.isPrimary() || property.isVirtual()) continue;
            Object value = values.get(name);
            LOG.trace("value: " + value);
            LOG.trace("condition: " + bind.getCondition());
            if (!this.newBean && bind.getConditionEmpty() == Boolean.TRUE && property.get(bean) != null) {
                LOG.trace("field is not empty");
                continue;
            }
            if (!this.validate(bind, value, ctx)) {
                LOG.trace("condition failed");
                continue;
            }
            if (bind.getExpression() != null) {
                LOG.trace("expression: " + bind.getExpression());
                value = bind.getNode() == null ? value : bind.evaluate(ctx);
                LOG.trace("value: " + value);
            }
            if (!(value instanceof Model)) {
                if (property.isReference()) {
                    value = this.relational(property, bind, value, ctx);
                } else if (property.isCollection() && value != null) {
                    if (!(value instanceof List)) {
                        value = Lists.newArrayList((Object[])new Object[]{value});
                    }
                    ArrayList items = Lists.newArrayList();
                    for (Object item : (List)value) {
                        items.add(this.relational(property, bind, item, ctx));
                    }
                    value = items;
                }
            }
            LOG.trace("set value: {} = {}", (Object)property.getName(), value);
            isNull = false;
            if (property.isCollection()) {
                if (value == null) continue;
                if (value instanceof Collection) {
                    property.addAll(bean, (Collection)value);
                    continue;
                }
                property.add(bean, value);
                continue;
            }
            if (AuditHelper.update(bean, field, value)) continue;
            property.set(bean, value);
        }
        return isNull ? null : bean;
    }

    private Object relational(Property property, XMLBind bind, Object value, Map<String, Object> ctx) {
        Object result;
        Map values = ctx;
        if (value instanceof Map) {
            values = (Map)value;
            for (String key : ctx.keySet()) {
                if (!key.startsWith("_")) continue;
                values.put(key, ctx.get(key));
            }
        }
        if ((result = this.bind(bind, property.getTarget(), values)) instanceof Model && (property.getType() == PropertyType.MANY_TO_ONE || property.getType() == PropertyType.MANY_TO_MANY) && !JPA.em().contains(result)) {
            result = JPA.manage((Model)result);
        }
        return result;
    }

    private Map<String, Object> toContext(Map<String, Object> map) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        if (this.context != null) {
            ctx.putAll(this.context);
        }
        if (map != null) {
            ctx.putAll(map);
        }
        return ctx;
    }

    private boolean validate(XMLBind binding, Object value, Map<String, Object> values) {
        Map<String, Object> ctx = this.toContext(value instanceof Map ? (Map)value : values);
        if (values != null) {
            for (String key : values.keySet()) {
                if (!key.startsWith("_")) continue;
                ctx.put(key, values.get(key));
            }
        }
        return binding.validate(ctx);
    }

    private Map<String, Object> toMap(Node node, XMLBind binding) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (XMLBind bind : binding.getBindings()) {
            String name = bind.getAlias();
            String path = bind.getNode();
            if (name == null) {
                name = bind.getField();
            }
            if (name == null) continue;
            List<Node> nodes = this.find(node, bind, ".");
            Object value = this.value(nodes, bind);
            if (!this.validate(bind, value = this.adapt(bind, value, map), map)) continue;
            if (bind.getNode() == null && bind.getExpression() != null) {
                value = bind.evaluate(this.toContext(map));
            }
            map.put(name, value);
        }
        return map;
    }

    private Object value(List<Node> nodes, final XMLBind bind) {
        List result = Lists.transform(nodes, (Function)new Function<Node, Object>(){

            public Object apply(@Nullable Node input) {
                if (bind.getBindings() != null) {
                    return XMLBinder.this.toMap(input, bind);
                }
                if (input.getNodeType() == 1) {
                    Node child = input.getFirstChild();
                    if (child == null) {
                        return null;
                    }
                    if (child.getNodeType() == 3) {
                        return child.getNodeValue();
                    }
                    return XMLBinder.this.toMap(input, bind);
                }
                return input.getNodeValue();
            }
        });
        if (result.size() == 1) {
            return result.get(0);
        }
        return result.size() == 0 ? null : result;
    }

    private Object adapt(XMLBind bind, Object value, Map<String, Object> ctx) {
        String name = bind.getAdapter();
        if (name == null || !this.adapters.containsKey(name)) {
            return value;
        }
        DataAdapter adapter = this.adapters.get(name);
        return adapter.adapt(value, ctx);
    }

    private List<Node> selectNodes(Node node, String path) throws XPathExpressionException {
        if (path.contains("../")) {
            if (this.xpath == null) {
                this.xpath = XPathFactory.newInstance().newXPath();
            }
            XPathExpression expression = this.xpath.compile(path);
            ArrayList<Node> nodes = new ArrayList<Node>();
            NodeList items = (NodeList)expression.evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < items.getLength(); ++i) {
                nodes.add(items.item(i));
            }
            return nodes;
        }
        return JXPathContext.newContext((Object)node).selectNodes(path);
    }

    private List<Node> find(Node node, XMLBind bind, String prefix) {
        String name;
        List<Object> nodes = Lists.newArrayList();
        String path = name = bind.getNode();
        if (name == null) {
            return nodes;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!"/".equals(prefix)) {
            path = prefix + path;
        }
        try {
            LOG.trace("xpath: " + path);
            nodes = this.selectNodes(node, path);
            LOG.trace("xpath match: " + nodes.size());
        }
        catch (Exception e) {
            LOG.error("Invalid xpath expression: {}", (Object)path);
        }
        return nodes;
    }

    private Object newInstance(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

