/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.db.EntityHelper;
import com.axelor.db.JpaScanner;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.db.mapper.PropertyType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Provider;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.jdbc.Work;

@Singleton
public final class JPA {
    private Provider<EntityManager> emp;
    private static JPA INSTANCE = null;

    @Inject
    private JPA(Provider<EntityManager> emp) {
        this.emp = emp;
        INSTANCE = this;
    }

    private static JPA get() {
        if (INSTANCE == null) {
            throw new RuntimeException("JPA context not initialized.");
        }
        return INSTANCE;
    }

    public static EntityManager em() {
        return (EntityManager)JPA.get().emp.get();
    }

    public static int execute(String query) {
        return JPA.em().createQuery(query).executeUpdate();
    }

    public static <T extends Model> Query<T> all(Class<T> klass) {
        return Query.of(klass);
    }

    public static <T extends Model> T find(Class<T> klass, Long id) {
        return (T)((Model)JPA.em().find(klass, (Object)id));
    }

    private static boolean isAutoFlushEnabled() {
        return !Objects.equal((Object)"false", JPA.em().getEntityManagerFactory().getProperties().get("JPA.auto_flush"));
    }

    public static <T extends Model> T persist(T entity) {
        JPA.checkVersion(entity, entity.getVersion());
        JPA.em().persist(entity);
        if (JPA.isAutoFlushEnabled()) {
            JPA.em().flush();
        }
        return entity;
    }

    public static <T extends Model> T merge(T entity) {
        JPA.checkVersion(entity, entity.getVersion());
        Model result = (Model)JPA.em().merge(entity);
        if (JPA.isAutoFlushEnabled()) {
            JPA.em().flush();
        }
        return (T)result;
    }

    public static <T extends Model> T save(T entity) {
        if (JPA.em().contains(entity) || entity.getId() == null) {
            return JPA.persist(entity);
        }
        return JPA.merge(entity);
    }

    public static <T extends Model> void remove(T entity) {
        EntityManager manager = JPA.em();
        if (manager.contains(entity)) {
            manager.remove(entity);
        } else {
            JPA.checkVersion(entity, entity.getVersion());
            Model attached = (Model)manager.find(entity.getClass(), (Object)entity.getId());
            manager.remove((Object)attached);
        }
    }

    public static <T extends Model> void refresh(T entity) {
        JPA.em().refresh(entity);
    }

    public static void flush() {
        JPA.em().flush();
    }

    public static void clear() {
        JPA.em().clear();
    }

    private static <T extends Model> void checkVersion(T bean, Object version) {
        if (bean == null || version == null) {
            return;
        }
        Class<T> klass = EntityHelper.getEntityClass(bean);
        Model entity = (Model)JPA.em().find(klass, (Object)bean.getId());
        if (entity == null || !Objects.equal((Object)version, (Object)entity.getVersion())) {
            StaleObjectStateException cause = new StaleObjectStateException(klass.getName(), (Serializable)bean.getId());
            throw new OptimisticLockException(cause.getMessage(), (Throwable)cause, bean);
        }
    }

    public static void verify(Class<? extends Model> model, Map<String, Object> values) {
        Model entity;
        if (values == null) {
            return;
        }
        Long id = null;
        try {
            id = Long.parseLong(values.get("id").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object version = values.get("version");
        Mapper mapper = Mapper.of(model);
        Model model2 = entity = id == null ? null : JPA.find(model, id);
        if (!(id == null || version == null || entity != null && Objects.equal((Object)version, (Object)entity.getVersion()))) {
            StaleObjectStateException cause = new StaleObjectStateException(model.getName(), (Serializable)id);
            throw new OptimisticLockException((Throwable)cause);
        }
        for (String key : values.keySet()) {
            Object value = values.get(key);
            Property property = mapper.getProperty(key);
            if (property == null || property.getTarget() == null || !(value instanceof Map) && !(value instanceof Collection)) continue;
            if (property.isCollection() && value instanceof Collection) {
                int size = 0;
                try {
                    size = ((Collection)property.get(entity)).size();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (size > ((Collection)value).size()) {
                    StaleObjectStateException cause = new StaleObjectStateException(model.getName(), (Serializable)id);
                    throw new OptimisticLockException((Throwable)cause);
                }
            }
            if (value instanceof Map) {
                value = Lists.newArrayList((Object[])new Object[]{value});
            }
            for (Object item : (Collection)value) {
                if (!(item instanceof Map)) continue;
                JPA.verify(property.getTarget(), (Map)item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> T edit(Class<T> klass, Map<String, Object> values) {
        HashSet visited = Sets.newHashSet();
        HashMultimap edited = HashMultimap.create();
        try {
            T t = JPA._edit(klass, values, visited, (Multimap<String, Long>)edited);
            return t;
        }
        finally {
            visited.clear();
            edited.clear();
        }
    }

    private static <T extends Model> T _edit(Class<T> klass, Map<String, Object> values, Set<Model> visited, Multimap<String, Long> edited) {
        if (values == null) {
            return null;
        }
        Mapper mapper = Mapper.of(klass);
        Long id = null;
        Model bean = null;
        try {
            id = Long.valueOf(values.get("id").toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (id == null || id <= 0L) {
            id = null;
            try {
                bean = (Model)klass.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            bean = (Model)JPA.em().find(klass, (Object)id);
            if (bean == null) {
                throw new OptimisticLockException((Throwable)new StaleObjectStateException(klass.getName(), (Serializable)id));
            }
        }
        Integer beanVersion = (Integer)values.get("version");
        boolean beanChanged = false;
        if (visited.contains(bean) && beanVersion == null) {
            return (T)bean;
        }
        visited.add(bean);
        if (id != null && (beanVersion == null || edited.containsEntry((Object)klass.getName(), (Object)id))) {
            return (T)bean;
        }
        if (id != null) {
            edited.put((Object)klass.getName(), (Object)id);
        }
        for (String name : values.keySet()) {
            Object oldValue;
            Property p = mapper.getProperty(name);
            if (p == null || p.isPrimary() || p.isVersion() || mapper.getSetter(name) == null) continue;
            Object value = values.get(name);
            Class<?> target = p.getTarget();
            if (p.isCollection()) {
                Object old;
                AbstractCollection items = new ArrayList();
                if (Set.class.isAssignableFrom(p.getJavaType())) {
                    items = new HashSet();
                }
                if (value instanceof Collection) {
                    for (Object val : (Collection)value) {
                        if (val instanceof Map) {
                            if (p.getMappedBy() != null) {
                                if (val instanceof ImmutableMap) {
                                    val = Maps.newHashMap((Map)((Map)val));
                                }
                                ((Map)val).remove(p.getMappedBy());
                            }
                            Object item = JPA._edit(target, (Map)val, visited, edited);
                            items.add(p.setAssociation(item, bean));
                            continue;
                        }
                        if (!(val instanceof Number)) continue;
                        items.add(JPA.find(target, Long.parseLong(val.toString())));
                    }
                }
                if ((old = mapper.get(bean, name)) instanceof Collection) {
                    boolean changed;
                    boolean bl = changed = ((Collection)old).size() != items.size();
                    if (!changed) {
                        for (Object item : items) {
                            if (((Collection)old).contains(item)) continue;
                            changed = true;
                            break;
                        }
                    }
                    if (!changed) continue;
                    if (p.isOrphan()) {
                        for (Object item : (Collection)old) {
                            if (items.contains(item)) continue;
                            p.setAssociation(item, null);
                        }
                    }
                    p.clear(bean);
                    p.addAll(bean, items);
                    beanChanged = true;
                    continue;
                }
                if (p.getType() == PropertyType.MANY_TO_MANY && p.getMappedBy() != null) {
                    p.addAll(bean, items);
                }
                value = items;
            } else if (p.isReference() && value instanceof Map) {
                value = JPA._edit(target, (Map)value, visited, edited);
            }
            if (!p.valueChanged(bean, oldValue = mapper.set(bean, name, value))) continue;
            beanChanged = true;
        }
        if (beanChanged) {
            JPA.checkVersion(bean, beanVersion);
        } else if (id != null) {
            edited.remove((Object)klass.getName(), (Object)id);
        }
        return (T)bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> T manage(T bean) {
        HashSet visited = Sets.newHashSet();
        try {
            T managed = JPA._manage(bean, visited);
            if (EntityHelper.isUninitialized(managed)) {
                T t = managed;
                return t;
            }
            T t = JPA.persist(managed);
            return t;
        }
        finally {
            visited.clear();
        }
    }

    private static <T extends Model> T _manage(T bean, Set<Model> visited) {
        if (visited.contains(bean) || EntityHelper.isUninitialized(bean)) {
            return bean;
        }
        visited.add(bean);
        Mapper mapper = Mapper.of(bean.getClass());
        for (Property property : mapper.getProperties()) {
            Object value;
            if (property.getTarget() == null || property.isReadonly() || (value = property.get(bean)) == null || value instanceof PersistentCollection && !((PersistentCollection)value).wasInitialized()) continue;
            if (property.isReference()) {
                JPA._manage((Model)value, visited);
                continue;
            }
            if (!property.isCollection()) continue;
            for (Object val : (Collection)value) {
                JPA._manage(property.setAssociation((Model)val, bean), visited);
            }
        }
        return bean;
    }

    public static Set<Class<?>> models() {
        return JpaScanner.findModels().stream().filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toSet());
    }

    public static Class<?> model(String name) {
        return JpaScanner.findModel(name);
    }

    public static <T extends Model> Property[] fields(Class<T> klass) {
        return Mapper.of(klass).getProperties();
    }

    public static <T extends Model> Property field(Class<T> klass, String name) {
        return Mapper.of(klass).getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> T copy(T bean, boolean deep) {
        HashSet visited = Sets.newHashSet();
        try {
            T t = JPA._copy(bean, deep, visited);
            return t;
        }
        finally {
            visited.clear();
        }
    }

    private static <T extends Model> T _copy(T bean, boolean deep, Set<String> visited) {
        if (bean == null) {
            return bean;
        }
        Class<?> beanClass = (bean = EntityHelper.getEntity(bean)).getClass();
        String key = beanClass.getName() + "#" + bean.getId();
        if (visited.contains(key)) {
            return null;
        }
        visited.add(key);
        Mapper mapper = Mapper.of(beanClass);
        Model obj = (Model)Mapper.toBean(beanClass, null);
        int random = new Random().nextInt();
        for (Property p : mapper.getProperties()) {
            if (p.isVirtual() || p.isPrimary() || p.isVersion() || p.isSequence() || !p.isCopyable() || p.getType() == PropertyType.ONE_TO_ONE) continue;
            HashSet value = p.get(bean);
            if (value instanceof List && deep) {
                ArrayList items = Lists.newArrayList();
                for (Object item : (List)((Object)value)) {
                    Model val = JPA.copy((Model)item, true);
                    p.setAssociation(val, null);
                    items.add(val);
                }
                value = items;
            } else if (value instanceof List) {
                value = null;
            } else if (value instanceof Set) {
                value = new HashSet(value);
            }
            if (value instanceof String && p.isUnique()) {
                value = (String)((Object)value) + " Copy (" + random + ")";
            }
            p.set(obj, value);
        }
        return (T)obj;
    }

    public static void runInTransaction(Runnable task) {
        Preconditions.checkNotNull((Object)task);
        EntityTransaction txn = JPA.em().getTransaction();
        boolean txnStarted = false;
        try {
            if (!txn.isActive()) {
                txn.begin();
                txnStarted = true;
            }
            task.run();
            if (txnStarted && txn.isActive() && !txn.getRollbackOnly()) {
                txn.commit();
            }
        }
        finally {
            if (txnStarted && txn.isActive()) {
                txn.rollback();
            }
        }
    }

    public static void jdbcWork(final JDBCWork work) {
        Session session = (Session)JPA.em().getDelegate();
        try {
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    work.execute(connection);
                }
            });
        }
        catch (HibernateException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public static interface JDBCWork {
        public void execute(Connection var1) throws SQLException;
    }
}

