/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.db.JpaScanner;

public class JpaClassLoader
extends ClassLoader {
    public JpaClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public JpaClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            Class<?> model = this.findModelClass(name);
            if (model != null) {
                return model;
            }
            throw e;
        }
    }

    private Class<?> findModelClass(String className) {
        if (!className.startsWith("java.lang.") || className.contains("$")) {
            return null;
        }
        String name = className.substring(className.lastIndexOf(46) + 1);
        Class<?> klass = JpaScanner.findRepository(name);
        if (klass == null) {
            klass = JpaScanner.findModel(name);
        }
        if (klass == null) {
            klass = JpaScanner.findEnum(name);
        }
        return klass;
    }
}

