/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.common.ResourceUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.persist.Transactional;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;

public class JpaFixture {
    private InputStream read(String resource) {
        return ResourceUtils.getResourceStream((String)("fixtures/" + resource));
    }

    @Transactional
    public void load(String fixture) {
        InputStream stream = this.read(fixture);
        final LinkedHashMap objects = Maps.newLinkedHashMap();
        if (stream == null) {
            throw new IllegalArgumentException("No such fixture found: " + fixture);
        }
        Constructor ctor = new Constructor(){
            {
                this.yamlClassConstructors.put(NodeId.scalar, new TimeStampConstruct());
            }

            protected Object constructObject(Node node) {
                Object obj = super.constructObject(node);
                if (objects.containsKey(node)) {
                    return objects.get(node);
                }
                if (obj instanceof Model) {
                    objects.put(node, obj);
                    return obj;
                }
                return obj;
            }

            class TimeStampConstruct
            extends Constructor.ConstructScalar {
                Construct dateConstructor;

                TimeStampConstruct() {
                    super((Constructor)this);
                    this.dateConstructor = (Construct)yamlConstructors.get(Tag.TIMESTAMP);
                }

                public Object construct(Node nnode) {
                    if (nnode.getTag().equals((Object)Tag.TIMESTAMP)) {
                        Date date = (Date)this.dateConstructor.construct(nnode);
                        if (nnode.getType() == LocalDate.class) {
                            return date.toInstant().atZone(ZoneOffset.UTC).toLocalDate();
                        }
                        if (nnode.getType() == LocalDateTime.class) {
                            return date.toInstant().atZone(ZoneOffset.UTC).toLocalDateTime();
                        }
                        return date.toInstant().atZone(ZoneOffset.UTC);
                    }
                    return super.construct(nnode);
                }
            }
        };
        for (Class<?> klass : JPA.models()) {
            ctor.addTypeDescription(new TypeDescription(klass, "!" + klass.getSimpleName() + ":"));
        }
        Yaml data = new Yaml((BaseConstructor)ctor);
        data.load(stream);
        for (Object item : Lists.reverse((List)Lists.newArrayList(objects.values()))) {
            try {
                JPA.manage((Model)item);
            }
            catch (Exception exception) {}
        }
    }
}

