/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.common.reflections.ClassFinder;
import com.axelor.db.JpaClassLoader;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.db.ValueEnum;
import com.axelor.meta.MetaScanner;
import com.axelor.rpc.ContextHandlerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.boot.archive.internal.StandardArchiveDescriptorFactory;
import org.hibernate.boot.archive.scan.internal.ClassDescriptorImpl;
import org.hibernate.boot.archive.scan.internal.ScanResultImpl;
import org.hibernate.boot.archive.scan.spi.AbstractScannerImpl;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.scan.spi.ScanEnvironment;
import org.hibernate.boot.archive.scan.spi.ScanOptions;
import org.hibernate.boot.archive.scan.spi.ScanParameters;
import org.hibernate.boot.archive.scan.spi.ScanResult;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaScanner
extends AbstractScannerImpl {
    private static Logger log = LoggerFactory.getLogger(JpaScanner.class);
    private static final Object lock = new Object();
    private static Map<String, Class<?>> modelCache = new HashMap();
    private static Map<String, Class<?>> repoCache = new HashMap();
    private static Map<String, Class<?>> enumCache = new HashMap();
    private static Map<String, String> modelNames = new HashMap<String, String>();
    private static Map<String, String> repoNames = new HashMap<String, String>();
    private static Map<String, String> enumNames = new HashMap<String, String>();
    private static Set<String> excludes = new HashSet<String>();
    private static Set<String> includes = new HashSet<String>();
    public static ClassLoader loader = new JpaClassLoader();

    public JpaScanner() {
        super((ArchiveDescriptorFactory)StandardArchiveDescriptorFactory.INSTANCE);
    }

    public static void exclude(String pkg) {
        includes.remove(pkg);
        excludes.add(pkg);
    }

    public static void include(String pkg) {
        excludes.remove(pkg);
        includes.add(pkg);
    }

    public ScanResult scan(ScanEnvironment environment, ScanOptions options, ScanParameters params) {
        ScanResult found = super.scan(environment, options, params);
        Set<Class<?>> models = JpaScanner.findClasses();
        HashSet<ClassDescriptorImpl> descriptors = new HashSet<ClassDescriptorImpl>();
        if (found.getLocatedClasses() != null) {
            descriptors.addAll(found.getLocatedClasses());
        }
        for (Class<?> model : models) {
            ClassDescriptorImpl descriptor = new ClassDescriptorImpl(model.getName(), ClassDescriptor.Categorization.MODEL, null);
            descriptors.add(descriptor);
        }
        return new ScanResultImpl(found.getLocatedPackages(), descriptors, found.getLocatedMappingFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Class<?>> findClasses() {
        Object object = lock;
        synchronized (object) {
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            Future<?> models = executor.submit(() -> {
                log.debug("Searching for entity classes...");
                modelCache.clear();
                modelNames.clear();
                JpaScanner.register(Model.class);
                ClassFinder finder = MetaScanner.findSubTypesOf(Model.class).having(Entity.class).having(Embeddable.class).having(MappedSuperclass.class);
                for (String pkg : includes) {
                    finder = finder.within(pkg);
                }
                for (Class klass : finder.any().find()) {
                    if (modelCache.containsKey(klass.getName()) || excludes.contains(klass.getPackage().getName())) continue;
                    log.trace("Found entity: {}", (Object)klass.getName());
                    JpaScanner.register(klass);
                }
                ContextHandlerFactory.refresh(modelCache.values());
                log.debug("Entity classes found: {}", (Object)modelCache.size());
            });
            Future<?> repos = executor.submit(() -> {
                log.debug("Searching for repository classes...");
                repoCache.clear();
                repoNames.clear();
                ClassFinder finder = MetaScanner.findSubTypesOf(JpaRepository.class);
                for (String pkg : includes) {
                    finder = finder.within(pkg);
                }
                for (Class klass : finder.any().find()) {
                    if (repoCache.containsKey(klass.getName()) || excludes.contains(klass.getPackage().getName())) continue;
                    log.trace("Found repository: {}", (Object)klass.getName());
                    repoCache.put(klass.getName(), klass);
                    repoNames.put(klass.getSimpleName(), klass.getName());
                }
                log.debug("Repository classes found: {}", (Object)repoCache.size());
            });
            Future<?> enums = executor.submit(() -> {
                log.debug("Searching for value enum classes...");
                enumCache.clear();
                enumNames.clear();
                ClassFinder finder = MetaScanner.findSubTypesOf(ValueEnum.class);
                for (String pkg : includes) {
                    finder = finder.within(pkg);
                }
                for (Class klass : finder.any().find()) {
                    if (enumCache.containsKey(klass.getName()) || excludes.contains(klass.getPackage().getName())) continue;
                    log.trace("Found value enum: {}", (Object)klass.getName());
                    enumCache.put(klass.getName(), klass);
                    enumNames.put(klass.getSimpleName(), klass.getName());
                }
                log.debug("Value enum classes found: {}", (Object)enumCache.size());
            });
            try {
                models.get();
                repos.get();
                enums.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                executor.shutdown();
            }
        }
        return new HashSet(modelCache.values());
    }

    private static void register(Class<?> model) {
        modelCache.put(model.getName(), model);
        modelNames.put(model.getSimpleName(), model.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> findModels() {
        Object object = lock;
        synchronized (object) {
            if (modelCache.isEmpty()) {
                return JpaScanner.findClasses();
            }
        }
        return new HashSet(modelCache.values());
    }

    public static ClassLoader getClassLoader() {
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findModel(String name) {
        Object object = lock;
        synchronized (object) {
            if (modelCache.isEmpty()) {
                JpaScanner.findClasses();
            }
        }
        return modelCache.get(modelNames.getOrDefault(name, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findRepository(String name) {
        Object object = lock;
        synchronized (object) {
            if (modelCache.isEmpty()) {
                JpaScanner.findClasses();
            }
        }
        return repoCache.get(repoNames.getOrDefault(name, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findEnum(String name) {
        Object object = lock;
        synchronized (object) {
            if (modelCache.isEmpty()) {
                JpaScanner.findClasses();
            }
        }
        return enumCache.get(enumNames.getOrDefault(name, name));
    }
}

