/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.rpc.filter.Filter;
import java.util.Set;

public interface JpaSecurity {
    public static final AccessType CAN_READ = AccessType.READ;
    public static final AccessType CAN_WRITE = AccessType.WRITE;
    public static final AccessType CAN_CREATE = AccessType.CREATE;
    public static final AccessType CAN_REMOVE = AccessType.REMOVE;
    public static final AccessType CAN_EXPORT = AccessType.EXPORT;

    public Set<AccessType> getAccessTypes(Class<? extends Model> var1, Long var2);

    public boolean hasRole(String var1);

    public Filter getFilter(AccessType var1, Class<? extends Model> var2, Long ... var3);

    public boolean isPermitted(AccessType var1, Class<? extends Model> var2, Long ... var3);

    public void check(AccessType var1, Class<? extends Model> var2, Long ... var3);

    public static enum AccessType {
        READ("You are not authorized to read this resource."),
        WRITE("You are not authorized to update this resource."),
        CREATE("You are not authorized to create this resource."),
        REMOVE("You are not authorized to remove this resource."),
        EXPORT("You are not authorized to export the data.");

        private String message;

        private AccessType(String message) {
            this.message = message;
        }

        public String getMessage() {
            return I18n.get(this.message);
        }
    }
}

