/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import com.axelor.app.AppSettings;
import com.axelor.db.JPA;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelTransactionExecutor {
    private final int numWorkers;
    private final ExecutorService workerPool;
    private final List<Future<?>> workerFutures;
    private final ConcurrentMap<Integer, Map.Entry<CountDownLatch, Queue<Runnable>>> commandsByPriority;
    private final List<Map.Entry<CountDownLatch, Queue<Runnable>>> commands;
    private boolean rollbackNeeded;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ParallelTransactionExecutor() {
        this(ParallelTransactionExecutor.getMaxWorkers());
    }

    private static int getMaxWorkers() {
        AppSettings settings = AppSettings.get();
        int maxPoolSize = settings.getInt("hibernate.hikari.maximumPoolSize", 0);
        int maxWorkers = Runtime.getRuntime().availableProcessors();
        return maxPoolSize > 0 && maxPoolSize < maxWorkers ? maxPoolSize : maxWorkers;
    }

    public ParallelTransactionExecutor(int numWorkers) {
        this.numWorkers = numWorkers;
        this.workerPool = Executors.newFixedThreadPool(numWorkers);
        this.workerFutures = new ArrayList(numWorkers);
        this.commandsByPriority = new ConcurrentHashMap<Integer, Map.Entry<CountDownLatch, Queue<Runnable>>>();
        this.commands = new ArrayList<Map.Entry<CountDownLatch, Queue<Runnable>>>();
    }

    public void add(Runnable command) {
        this.add(command, 0);
    }

    public void add(Runnable command, int priority) {
        ((Queue)this.commandsByPriority.computeIfAbsent(priority, key -> new AbstractMap.SimpleImmutableEntry(new CountDownLatch(this.numWorkers), new ConcurrentLinkedQueue())).getValue()).add(command);
    }

    public void run() {
        this.start();
        this.waitAndShutdown();
    }

    private void start() {
        this.commandsByPriority.keySet().stream().sorted().forEachOrdered(priority -> this.commands.add((Map.Entry<CountDownLatch, Queue<Runnable>>)this.commandsByPriority.get(priority)));
        for (int i = 0; i < this.numWorkers; ++i) {
            this.workerFutures.add(this.workerPool.submit(this::runCommandsInTransaction));
        }
    }

    private void waitAndShutdown() {
        try {
            this.workerFutures.forEach(future -> {
                try {
                    this.wait((Future<?>)future);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ErrorInAnotherWorker) {
                        return;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new IllegalStateException(cause);
                }
            });
        }
        finally {
            this.workerPool.shutdown();
        }
    }

    private void wait(Future<?> future) throws InterruptedException, ExecutionException {
        while (true) {
            try {
                future.get(1L, TimeUnit.HOURS);
                return;
            }
            catch (TimeoutException e) {
                logger.warn("Furure {} of pool {} is taking a long time to complete.", future, (Object)this.workerPool);
                if (!Thread.currentThread().isInterrupted()) continue;
                return;
            }
            break;
        }
    }

    private void runCommandsInTransaction() {
        JPA.runInTransaction(() -> {
            RuntimeException error = null;
            for (Map.Entry<CountDownLatch, Queue<Runnable>> entry : this.commands) {
                CountDownLatch doneSignal = entry.getKey();
                Queue<Runnable> commandQueue = entry.getValue();
                try {
                    Runnable command;
                    while ((command = commandQueue.poll()) != null) {
                        command.run();
                    }
                }
                catch (RuntimeException e) {
                    this.rollbackNeeded = true;
                    error = e;
                    this.clearCommandQueues();
                }
                finally {
                    doneSignal.countDown();
                }
                try {
                    doneSignal.await();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (error != null) {
                throw error;
            }
            if (this.rollbackNeeded) {
                throw new ErrorInAnotherWorker();
            }
        });
    }

    private void clearCommandQueues() {
        this.commands.parallelStream().map(Map.Entry::getValue).forEach(Collection::clear);
    }

    private static class ErrorInAnotherWorker
    extends RuntimeException {
        private static final long serialVersionUID = 5171709514475835079L;

        private ErrorInAnotherWorker() {
        }
    }
}

