/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db;

import java.util.Objects;

public interface ValueEnum<T> {
    public T getValue();

    public static <T extends Enum<T>> T of(Class<T> enumType, Object value) {
        if (value == null) {
            throw new NullPointerException("Value is null.");
        }
        if (value instanceof Enum) {
            return (T)((Enum)enumType.cast(value));
        }
        if (ValueEnum.class.isAssignableFrom(enumType)) {
            for (Enum item : (Enum[])enumType.getEnumConstants()) {
                if (!Objects.equals(((ValueEnum)((Object)item)).getValue(), value)) continue;
                return (T)item;
            }
        }
        if (value instanceof String) {
            try {
                return Enum.valueOf(enumType, (String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("No enum constant found in " + enumType.getCanonicalName() + " for value: " + value);
    }
}

