/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.dialect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.PersistenceException;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public abstract class AbstractJsonExtractFunction
implements SQLFunction {
    private static final Pattern NAME_PATTERN = Pattern.compile("\\w+(\\.\\w+)*");
    private static final Pattern ARGS_PATTERN = Pattern.compile("'\\w+'");
    private Type type;
    private String name;
    private String cast;

    public AbstractJsonExtractFunction(String name, Type type, String cast) {
        this.type = type;
        this.name = name;
        this.cast = cast;
    }

    public String getName() {
        return this.name;
    }

    public String getCast() {
        return this.cast;
    }

    public Type getType() {
        return this.type;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Type getReturnType(Type firstArgumentType, Mapping mapping) throws QueryException {
        return this.type == null ? firstArgumentType : this.type;
    }

    protected abstract String transformPath(List<String> var1);

    protected String transformFunction(String func) {
        return func;
    }

    private static String validateField(String name) {
        if (NAME_PATTERN.matcher(name).matches()) {
            return name;
        }
        throw new PersistenceException("Invalid field name: " + name);
    }

    private static String validateArg(String name) {
        if (ARGS_PATTERN.matcher(name).matches()) {
            return name;
        }
        throw new PersistenceException("Invalid json field: " + name);
    }

    public String render(Type firstArgumentType, List arguments, SessionFactoryImplementor factory) {
        StringBuilder buf = new StringBuilder();
        Iterator iter = arguments.iterator();
        ArrayList<String> path = new ArrayList<String>();
        buf.append(this.getName()).append("(");
        buf.append(AbstractJsonExtractFunction.validateField((String)iter.next()));
        while (iter.hasNext()) {
            path.add(AbstractJsonExtractFunction.validateArg((String)iter.next()));
        }
        buf.append(", ");
        buf.append(this.transformPath(path));
        buf.append(")");
        String func = this.transformFunction(buf.toString());
        return this.cast == null ? func : String.format("cast(nullif(%s, '') as %s)", func, this.cast);
    }
}

