/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.hibernate.type;

import com.axelor.db.ValueEnum;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;

public class ValueEnumType
implements DynamicParameterizedType,
UserType,
Serializable {
    private int sqlType;
    private Class<? extends ValueEnum<?>> enumType;

    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType params = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        this.enumType = params.getReturnedClass();
        if (!this.enumType.isEnum()) {
            throw new RuntimeException("Not enum type " + this.enumType.getName());
        }
        ValueEnum<?>[] enums = this.enumType.getEnumConstants();
        if (enums == null || enums.length == 0) {
            throw new RuntimeException("Invalid enum type " + this.enumType.getName());
        }
        this.sqlType = enums[0].getValue() instanceof Integer ? 4 : 12;
    }

    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    public Class<? extends ValueEnum<?>> returnedClass() {
        return this.enumType;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x == null ? 0 : x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Object value = rs.getObject(names[0]);
        return rs.wasNull() ? null : ValueEnum.of(this.returnedClass().asSubclass(Enum.class), value);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlType);
        } else {
            st.setObject(index, ((ValueEnum)value).getValue());
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

