/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.internal;

import com.axelor.app.AppSettings;
import com.axelor.common.ResourceUtils;
import com.axelor.common.StringUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.w3c.dom.Document;

public class DBHelper {
    private static Boolean unaccentSupport = null;
    private static final int DEFAULT_BATCH_SIZE = 20;
    private static final int DEFAULT_FETCH_SIZE = 20;
    private static final String UNACCENT_CHECK = "SELECT unaccent('text')";
    private static final String UNACCENT_CREATE = "CREATE EXTENSION IF NOT EXISTS unaccent";
    private static final String XPATH_ROOT = "/persistence/persistence-unit";
    private static final String XPATH_NON_JTA_DATA_SOURCE = "non-jta-data-source";
    private static final String XPATH_SHARED_CACHE_MODE = "shared-cache-mode";
    private static final String XPATH_PERSISTENCE_DRIVER = "properties/property[@name='javax.persistence.jdbc.driver']/@value";
    private static final String XPATH_PERSISTENCE_URL = "properties/property[@name='javax.persistence.jdbc.url']/@value";
    private static final String XPATH_PERSISTENCE_USER = "properties/property[@name='javax.persistence.jdbc.user']/@value";
    private static final String XPATH_PERSISTENCE_PASSWORD = "properties/property[@name='javax.persistence.jdbc.password']/@value";
    private static final String XPATH_BATCH_SIZE = "properties/property[@name='hibernate.jdbc.batch_size']/@value";
    private static final String XPATH_FETCH_SIZE = "properties/property[@name='hibernate.jdbc.fetch_size']/@value";
    private static String jndiName;
    private static String cacheMode;
    private static String jdbcDriver;
    private static String jdbcUrl;
    private static String jdbcUser;
    private static String jdbcPassword;
    private static int jdbcBatchSize;
    private static int jdbcFetchSize;

    private DBHelper() {
    }

    private static String evaluate(XPath xpath, String base, String path, Document document) {
        try {
            return xpath.evaluate(base + "/" + path, document).trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void initialize() {
        AppSettings settings = AppSettings.get();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        try (InputStream res = ResourceUtils.getResourceStream((String)"META-INF/persistence.xml");){
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(res);
            String jpaUnit = DBHelper.evaluate(xpath, XPATH_ROOT, "@name", document);
            String pu = jpaUnit.replaceAll("(PU|Unit)$", "").replaceAll("^persistence$", "default");
            if (StringUtils.isBlank((CharSequence)pu)) {
                throw new RuntimeException("Invalid persistence.xml, missing persistence unit name.");
            }
            String configDataSource = String.format("db.%s.datasource", pu);
            String configDriver = String.format("db.%s.driver", pu);
            String configUrl = String.format("db.%s.url", pu);
            String configUser = String.format("db.%s.user", pu);
            String configPassword = String.format("db.%s.password", pu);
            jndiName = settings.get(configDataSource);
            jdbcDriver = settings.get(configDriver);
            jdbcUrl = settings.get(configUrl);
            jdbcUser = settings.get(configUser);
            jdbcPassword = settings.get(configPassword);
            jdbcBatchSize = settings.getInt("hibernate.jdbc.batch_size", 20);
            jdbcFetchSize = settings.getInt("hibernate.jdbc.fetch_size", 20);
            cacheMode = DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_SHARED_CACHE_MODE, document);
            if (StringUtils.isBlank((CharSequence)jndiName)) {
                try {
                    jdbcBatchSize = Integer.parseInt(DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_BATCH_SIZE, document));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    jdbcFetchSize = Integer.parseInt(DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_FETCH_SIZE, document));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isBlank((CharSequence)jndiName)) {
                jndiName = DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_NON_JTA_DATA_SOURCE, document);
            }
            if (StringUtils.isBlank((CharSequence)jndiName) && StringUtils.isBlank((CharSequence)jdbcDriver)) {
                jdbcDriver = DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_PERSISTENCE_DRIVER, document);
                jdbcUrl = DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_PERSISTENCE_URL, document);
                jdbcUser = DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_PERSISTENCE_USER, document);
                jdbcPassword = DBHelper.evaluate(xpath, XPATH_ROOT, XPATH_PERSISTENCE_PASSWORD, document);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Connection getConnection() throws NamingException, SQLException {
        if (!StringUtils.isBlank((CharSequence)jndiName)) {
            DataSource ds = (DataSource)InitialContext.doLookup(jndiName);
            return ds.getConnection();
        }
        try {
            Class.forName(jdbcDriver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPassword);
    }

    public static void migrate() {
        Flyway flyway = new Flyway();
        if (!StringUtils.isBlank((CharSequence)jndiName)) {
            try {
                flyway.setDataSource((DataSource)InitialContext.doLookup(jndiName));
            }
            catch (NamingException e) {
                throw new FlywayException((Throwable)e);
            }
        } else {
            flyway.setDataSource(jdbcUrl, jdbcUser, jdbcPassword, new String[0]);
        }
        flyway.migrate();
    }

    public static String getDataSourceName() {
        return jndiName;
    }

    public static boolean isDataSourceUsed() {
        return !StringUtils.isBlank((CharSequence)jndiName);
    }

    public static boolean isCacheEnabled() {
        if (StringUtils.isBlank((CharSequence)cacheMode)) {
            return false;
        }
        if (cacheMode.equals("ALL")) {
            return true;
        }
        return cacheMode.equals("ENABLE_SELECTIVE");
    }

    public static boolean isOracle() {
        return jdbcDriver != null && jdbcDriver.contains("Oracle");
    }

    public static boolean isMySQL() {
        return jdbcDriver != null && jdbcDriver.contains("mysql");
    }

    public static int getJdbcBatchSize() {
        return jdbcBatchSize;
    }

    public static int getJdbcFetchSize() {
        return jdbcFetchSize;
    }

    public static boolean isUnaccentEnabled() {
        if (unaccentSupport == null) {
            try {
                unaccentSupport = DBHelper.testUnaccent();
            }
            catch (Exception e) {
                unaccentSupport = Boolean.FALSE;
            }
        }
        return unaccentSupport == Boolean.TRUE;
    }

    private static boolean testUnaccent() throws Exception {
        Connection connection = DBHelper.getConnection();
        Statement stmt = connection.createStatement();
        try {
            stmt.executeQuery(UNACCENT_CHECK);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            try {
                stmt.executeUpdate(UNACCENT_CREATE);
                boolean bl = true;
                return bl;
            }
            catch (Exception exception2) {
            }
        }
        finally {
            stmt.close();
            connection.close();
        }
        return false;
    }

    static {
        DBHelper.initialize();
    }
}

