/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.mapper;

import com.axelor.db.mapper.types.DecimalAdapter;
import com.axelor.db.mapper.types.EnumAdapter;
import com.axelor.db.mapper.types.JavaTimeAdapter;
import com.axelor.db.mapper.types.ListAdapter;
import com.axelor.db.mapper.types.MapAdapter;
import com.axelor.db.mapper.types.SetAdapter;
import com.axelor.db.mapper.types.SimpleAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Adapter {
    private static SimpleAdapter simpleAdapter = new SimpleAdapter();
    private static ListAdapter listAdapter = new ListAdapter();
    private static SetAdapter setAdapter = new SetAdapter();
    private static MapAdapter mapAdapter = new MapAdapter();
    private static JavaTimeAdapter javaTimeAdapter = new JavaTimeAdapter();
    private static EnumAdapter enumAdapter = new EnumAdapter();
    private static DecimalAdapter decimalAdapter = new DecimalAdapter();

    public static Object adapt(Object value, Class<?> type, Type genericType, Annotation[] annotations) {
        if (annotations == null) {
            annotations = new Annotation[]{};
        }
        if (type.isEnum()) {
            return enumAdapter.adapt(value, type, genericType, annotations);
        }
        if (value instanceof Collection && List.class.isAssignableFrom(type)) {
            return listAdapter.adapt(value, type, genericType, annotations);
        }
        if (value instanceof Collection && Set.class.isAssignableFrom(type)) {
            return setAdapter.adapt(value, type, genericType, annotations);
        }
        if (value instanceof Map) {
            return mapAdapter.adapt(value, type, genericType, annotations);
        }
        if (value instanceof Collection) {
            AbstractCollection all = value instanceof Set ? new HashSet() : new ArrayList();
            for (Object item : (Collection)value) {
                all.add(Adapter.adapt(item, type, genericType, annotations));
            }
            return all;
        }
        if (type.isInstance(value)) {
            return value;
        }
        if (javaTimeAdapter.isJavaTimeObject(type)) {
            return javaTimeAdapter.adapt(value, type, genericType, annotations);
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return decimalAdapter.adapt(value, type, genericType, annotations);
        }
        return simpleAdapter.adapt(value, type, genericType, annotations);
    }
}

