/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.mapper;

import com.axelor.common.Inflector;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Sequence;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.db.converters.AbstractEncryptedConverter;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.PropertyType;
import com.axelor.i18n.I18n;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

public class Property {
    private transient Class<?> entity;
    private String name;
    private PropertyType type;
    private transient Class<?> javaType;
    private transient java.lang.reflect.Type genericType;
    private String mappedBy;
    private Class<?> target;
    private String targetName;
    private List<String> targetSearch;
    private Class<?> enumType;
    private boolean primary;
    private boolean required;
    private boolean unique;
    private boolean orphan;
    private transient boolean hashKey;
    private transient boolean copyable;
    private Object maxSize;
    private Object minSize;
    private int precision;
    private int scale;
    private String title;
    private String help;
    private boolean image;
    private boolean nullable;
    private boolean readonly;
    private boolean hidden;
    private boolean virtual;
    private boolean transient_;
    private boolean json;
    private boolean password;
    private boolean massUpdate;
    private boolean nameColumn;
    private boolean sequence;
    private boolean translatable;
    private boolean encrypted;
    private boolean defaultNow;
    private transient String sequenceName;
    private String[] nameSearch;
    private String selection;

    Property(Class<?> entity, String name, Class<?> javaType, java.lang.reflect.Type genericType, Annotation[] annotations) {
        this.entity = entity;
        this.name = name;
        this.javaType = javaType;
        this.genericType = genericType;
        this.copyable = true;
        try {
            this.type = PropertyType.get(javaType.getSimpleName().toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (javaType.isEnum()) {
            this.type = PropertyType.ENUM;
            this.enumType = javaType;
        }
        for (Annotation annotation : annotations) {
            Class converter;
            Min m;
            if (annotation instanceof Lob) {
                if (this.type == PropertyType.STRING) {
                    this.type = PropertyType.TEXT;
                } else if (this.type != PropertyType.TEXT) {
                    this.type = PropertyType.BINARY;
                }
            }
            if (javaType == BigDecimal.class) {
                this.type = PropertyType.DECIMAL;
            }
            if (annotation instanceof OneToOne) {
                this.type = PropertyType.ONE_TO_ONE;
                this.target = javaType;
                this.mappedBy = ((OneToOne)annotation).mappedBy();
            }
            if (annotation instanceof ManyToOne) {
                this.type = PropertyType.MANY_TO_ONE;
                this.target = javaType;
            }
            if (annotation instanceof OneToMany) {
                this.type = PropertyType.ONE_TO_MANY;
                this.target = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                this.mappedBy = ((OneToMany)annotation).mappedBy();
                boolean bl = this.orphan = !((OneToMany)annotation).orphanRemoval();
            }
            if (annotation instanceof ManyToMany) {
                this.type = PropertyType.MANY_TO_MANY;
                this.target = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                this.mappedBy = ((ManyToMany)annotation).mappedBy();
            }
            if (annotation instanceof Id) {
                this.primary = true;
                this.readonly = true;
                this.hidden = true;
            }
            if (annotation instanceof Version) {
                this.readonly = true;
                this.hidden = true;
            }
            if (annotation instanceof Column) {
                this.unique = ((Column)annotation).unique();
                this.nullable = ((Column)annotation).nullable();
            }
            if (annotation instanceof NotNull) {
                this.required = true;
            }
            if (annotation instanceof Size) {
                Size s = (Size)annotation;
                this.maxSize = s.max();
                this.minSize = s.min();
            }
            if (annotation instanceof Digits) {
                Digits d = (Digits)annotation;
                this.scale = d.fraction();
                this.precision = d.integer() + this.scale;
            }
            if (annotation instanceof Min) {
                m = (Min)annotation;
                this.minSize = m.value();
            }
            if (annotation instanceof Max) {
                m = (Max)annotation;
                this.maxSize = m.value();
            }
            if (annotation instanceof DecimalMin) {
                m = (DecimalMin)annotation;
                this.minSize = m.value();
            }
            if (annotation instanceof DecimalMax) {
                m = (DecimalMax)annotation;
                this.maxSize = m.value();
            }
            if (annotation instanceof VirtualColumn) {
                this.readonly = true;
                this.virtual = true;
            }
            if (annotation instanceof NameColumn) {
                this.nameColumn = true;
            }
            if (annotation instanceof Transient) {
                this.transient_ = true;
            }
            if (annotation instanceof HashKey) {
                this.hashKey = true;
            }
            if (annotation instanceof Sequence) {
                this.sequence = true;
                this.sequenceName = ((Sequence)annotation).value();
            }
            if (annotation instanceof Type) {
                this.json = "json".equalsIgnoreCase(((Type)annotation).type());
                this.encrypted = "encrypted_text".equalsIgnoreCase(((Type)annotation).type());
            }
            if (annotation instanceof Convert && AbstractEncryptedConverter.class.isAssignableFrom(converter = ((Convert)annotation).converter())) {
                this.encrypted = true;
            }
            if (!(annotation instanceof Widget)) continue;
            Widget w = (Widget)annotation;
            this.title = w.title();
            this.help = w.help();
            this.readonly = w.readonly();
            this.hidden = w.hidden();
            this.nameSearch = w.search();
            this.selection = w.selection();
            this.password = w.password();
            this.massUpdate = w.massUpdate();
            this.copyable = w.copyable();
            this.translatable = w.translatable();
            this.defaultNow = w.defaultNow();
            if (w.multiline() && this.type == PropertyType.STRING) {
                this.type = PropertyType.TEXT;
            }
            if (this.type != PropertyType.BINARY) continue;
            this.image = w.image();
        }
        if (this.type == null) {
            throw new IllegalArgumentException(String.format("Invalid property of type '%s': %s", javaType.getName(), name));
        }
    }

    public Class<?> getEntity() {
        return this.entity;
    }

    public String getName() {
        return this.name;
    }

    public PropertyType getType() {
        return this.type;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public java.lang.reflect.Type getGenericType() {
        return this.genericType;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public Class<?> getTarget() {
        return this.target;
    }

    public String getTargetName() {
        if (this.targetName == null) {
            this.findTargetName();
        }
        return this.targetName;
    }

    public List<String> getTargetSearch() {
        if (this.targetName == null) {
            this.findTargetName();
        }
        return this.targetSearch;
    }

    public Class<?> getEnumType() {
        return this.enumType;
    }

    private void findTargetName() {
        if (this.target == null) {
            return;
        }
        Mapper mapper = Mapper.of(this.target);
        Property nameField = mapper.getNameField();
        Property codeField = mapper.getProperty("code");
        String targetName = null;
        LinkedHashSet<String> targetSearch = new LinkedHashSet<String>();
        if (nameField != null) {
            targetName = nameField.getName();
            targetSearch.add(targetName);
            if (nameField.getNameSearch() != null) {
                targetSearch.addAll(Arrays.asList(nameField.getNameSearch()));
            }
        }
        if (codeField != null && codeField.getType() == PropertyType.STRING) {
            targetSearch.add(codeField.getName());
        }
        this.targetName = targetName;
        this.targetSearch = new ArrayList<String>(targetSearch);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isVersion() {
        return "version".equals(this.name);
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public boolean isHashKey() {
        return this.hashKey;
    }

    public boolean isCopyable() {
        return this.copyable;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isTransient() {
        return this.transient_;
    }

    public boolean isJson() {
        return this.json;
    }

    public boolean isEnum() {
        return this.type == PropertyType.ENUM;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isMassUpdate() {
        if (this.isCollection() || this.isUnique()) {
            return false;
        }
        return this.massUpdate;
    }

    public boolean isReference() {
        return this.type == PropertyType.MANY_TO_ONE || this.type == PropertyType.ONE_TO_ONE;
    }

    public boolean isCollection() {
        return this.type == PropertyType.ONE_TO_MANY || this.type == PropertyType.MANY_TO_MANY;
    }

    public Object getMaxSize() {
        return this.maxSize;
    }

    public Object getMinSize() {
        return this.minSize;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHelp() {
        return this.help;
    }

    public boolean isImage() {
        return this.image;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public boolean isTranslatable() {
        return this.translatable;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isDefaultNow() {
        return this.defaultNow;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public boolean isNameColumn() {
        return this.nameColumn;
    }

    public String[] getNameSearch() {
        return this.nameSearch;
    }

    public String getSelection() {
        return this.selection;
    }

    public Object get(Object bean) {
        return Mapper.of(this.entity).get(bean, this.name);
    }

    public Object set(Object bean, Object value) {
        Object old = this.get(bean);
        if (old == value) {
            return value;
        }
        if (this.isCollection()) {
            this.clear(bean);
            if (value instanceof Collection) {
                this.addAll(bean, (Collection)value);
            } else {
                this.add(bean, value);
            }
        } else if (Mapper.of(this.entity).getSetter(this.name) != null) {
            Mapper.of(this.entity).set(bean, this.name, this.setAssociation(value, bean));
        }
        return old;
    }

    public Object add(Object bean, Object item) {
        return this.add(bean, item, true);
    }

    private Object add(Object bean, Object item, boolean associate) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((boolean)this.entity.isInstance(bean));
        Preconditions.checkState((boolean)this.isCollection());
        if (item == null) {
            return this.clear(bean);
        }
        Preconditions.checkArgument((boolean)this.target.isInstance(item));
        Collection items = (HashSet<Object>)this.get(bean);
        if (items == null) {
            items = Set.class.isAssignableFrom(this.javaType) ? new HashSet() : new ArrayList();
            Mapper.of(this.entity).set(bean, this.name, items);
            items = (Collection)this.get(bean);
        }
        if (associate) {
            items.add(this.setAssociation(item, bean));
        } else {
            items.add(item);
        }
        return bean;
    }

    public Object addAll(Object bean, Collection<?> items) {
        if (items != null) {
            for (Object item : items) {
                this.add(bean, item);
            }
        }
        return bean;
    }

    public <T, U> U setAssociation(U child, T bean) {
        if (this.mappedBy == null || child == null) {
            return child;
        }
        Property mapped = Mapper.of(this.target).getProperty(this.mappedBy);
        if (mapped == null) {
            return child;
        }
        if (mapped.isCollection()) {
            mapped.add(child, bean, false);
            return child;
        }
        if (mapped.get(child) != bean) {
            mapped.set(child, bean);
        }
        return child;
    }

    public Object clear(Object bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((boolean)this.entity.isInstance(bean));
        Preconditions.checkState((boolean)this.isCollection());
        Collection items = (Collection)this.get(bean);
        if (items == null || items.isEmpty()) {
            return bean;
        }
        Property mapped = Mapper.of(this.target).getProperty(this.mappedBy);
        if (mapped != null && mapped.isCollection()) {
            for (Object item : items) {
                Collection inverse = (Collection)mapped.get(item);
                if (inverse == null) continue;
                inverse.remove(bean);
            }
        }
        try {
            ((Collection)this.get(bean)).clear();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return bean;
    }

    public boolean valueChanged(Object bean, Object oldValue) {
        Object current = this.get(bean);
        if (current instanceof BigDecimal && oldValue instanceof BigDecimal) {
            return ((BigDecimal)current).compareTo((BigDecimal)oldValue) != 0;
        }
        return !Objects.equal((Object)current, (Object)oldValue);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : this.getClass().getDeclaredFields()) {
            Object value = null;
            try {
                value = field.get(this);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value == null || Modifier.isTransient(field.getModifiers()) || value instanceof String && ((String)value).equals("") || value instanceof Boolean && !((Boolean)value).booleanValue() || value instanceof Integer && (Integer)value == 0 || value instanceof Object[] && ((Object[])value).length == 0) continue;
            String key = field.getName().replaceAll("_+$", "");
            if ("help".equals(key) && "true".equals(value)) {
                value = "help:" + this.entity.getSimpleName() + "." + this.name;
            }
            if (value != null && key.matches("help|title")) {
                value = I18n.get(value.toString());
            }
            map.put(key, value);
        }
        if (!map.containsKey("title")) {
            map.put("title", I18n.get(Inflector.getInstance().humanize(this.getName())));
        }
        if (this.target != null) {
            map.put("targetName", this.getTargetName());
            map.put("targetSearch", this.getTargetSearch());
        }
        return map;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.toMap() + ")";
    }
}

