/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.mapper.types;

import com.axelor.db.mapper.TypeAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.Date;

public class JavaTimeAdapter
implements TypeAdapter<Object> {
    private DateTimeAdapter dateTimeAdapter = new DateTimeAdapter();
    private LocalDateAdapter localDateAdapter = new LocalDateAdapter();
    private LocalTimeAdapter localTimeAdapter = new LocalTimeAdapter();
    private LocalDateTimeAdapter localDateTimeAdapter = new LocalDateTimeAdapter();

    @Override
    public Object adapt(Object value, Class<?> actualType, Type genericType, Annotation[] annotations) {
        if (value == null || value instanceof String && "".equals(((String)value).trim())) {
            return null;
        }
        if (ZonedDateTime.class.isAssignableFrom(actualType)) {
            return this.dateTimeAdapter.adapt(value, actualType, genericType, annotations);
        }
        if (LocalDate.class.isAssignableFrom(actualType)) {
            return this.localDateAdapter.adapt(value, actualType, genericType, annotations);
        }
        if (LocalTime.class.isAssignableFrom(actualType)) {
            return this.localTimeAdapter.adapt(value, actualType, genericType, annotations);
        }
        if (LocalDateTime.class.isAssignableFrom(actualType)) {
            return this.localDateTimeAdapter.adapt(value, actualType, genericType, annotations);
        }
        return value;
    }

    public boolean isJavaTimeObject(Class<?> actualType) {
        return ZonedDateTime.class.isAssignableFrom(actualType) || LocalDate.class.isAssignableFrom(actualType) || LocalTime.class.isAssignableFrom(actualType) || LocalDateTime.class.isAssignableFrom(actualType);
    }

    private ZonedDateTime toZonedDateTime(Object value) {
        if (value == null) {
            return ZonedDateTime.now();
        }
        if (value instanceof ZonedDateTime) {
            return (ZonedDateTime)value;
        }
        if (value instanceof Date) {
            return ((Date)value).toInstant().atZone(ZoneId.systemDefault());
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).toInstant().atZone(ZoneId.systemDefault());
        }
        try {
            return ZonedDateTime.from((Temporal)value);
        }
        catch (Exception exception) {
            try {
                return OffsetDateTime.parse(value.toString()).atZoneSameInstant(ZoneId.systemDefault());
            }
            catch (Exception exception2) {
                try {
                    return LocalDateTime.parse(value.toString()).atZone(ZoneId.systemDefault());
                }
                catch (Exception exception3) {
                    try {
                        return LocalDate.parse(value.toString()).atStartOfDay(ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault());
                    }
                    catch (Exception exception4) {
                        throw new IllegalArgumentException("Unable to convert value: " + value);
                    }
                }
            }
        }
    }

    class LocalDateTimeAdapter
    implements TypeAdapter<LocalDateTime> {
        LocalDateTimeAdapter() {
        }

        @Override
        public Object adapt(Object value, Class<?> actualType, Type genericType, Annotation[] annotations) {
            return value instanceof LocalDateTime ? value : JavaTimeAdapter.this.toZonedDateTime(value).toLocalDateTime();
        }
    }

    class LocalTimeAdapter
    implements TypeAdapter<LocalTime> {
        LocalTimeAdapter() {
        }

        @Override
        public Object adapt(Object value, Class<?> actualType, Type genericType, Annotation[] annotations) {
            try {
                return value instanceof LocalTime ? value : JavaTimeAdapter.this.toZonedDateTime(value).toLocalTime();
            }
            catch (Exception e) {
                ZonedDateTime dt = ZonedDateTime.now();
                String val = String.format("%d-%02d-%02dT%s", dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), value);
                return JavaTimeAdapter.this.toZonedDateTime(val).toLocalTime();
            }
        }
    }

    class LocalDateAdapter
    implements TypeAdapter<LocalDate> {
        LocalDateAdapter() {
        }

        @Override
        public Object adapt(Object value, Class<?> actualType, Type genericType, Annotation[] annotations) {
            return value instanceof LocalDate ? value : JavaTimeAdapter.this.toZonedDateTime(value).toLocalDate();
        }
    }

    class DateTimeAdapter
    implements TypeAdapter<ZonedDateTime> {
        DateTimeAdapter() {
        }

        @Override
        public Object adapt(Object value, Class<?> actualType, Type genericType, Annotation[] annotations) {
            return value instanceof ZonedDateTime ? value : JavaTimeAdapter.this.toZonedDateTime(value);
        }
    }
}

