/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.tenants;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.tenants.TenantConfig;
import com.axelor.db.tenants.TenantConfigProvider;
import com.axelor.db.tenants.TenantModule;
import com.axelor.db.tenants.TenantNotFoundException;
import com.axelor.db.tenants.TenantResolver;
import com.axelor.db.tenants.TenantSupport;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractTenantFilter
implements Filter {
    protected static final String TENANT_COOKIE_NAME = "TENANTID";
    protected static final String TENANT_LOGIN_PARAM = "tenantId";
    protected static final String SESSION_KEY_TENANT_MAP = "tenantMap";
    protected static final String SESSION_KEY_TENANT_ID = "tenantId";
    protected static final List<String> SESSION_KEY_PREFIX_KEEP_LIST = ImmutableList.of((Object)"org.apache.shiro", (Object)"pac4j", (Object)"com.axelor.internal");
    private boolean enabled;
    private AtomicBoolean cleared = new AtomicBoolean();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.enabled = TenantModule.isEnabled();
    }

    public void destroy() {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled) {
            this.doFilterInternal(request, response, chain);
        } else {
            if (!this.cleared.getAndSet(true)) {
                ((HttpServletRequest)request).removeAttribute(SESSION_KEY_TENANT_MAP);
            }
            chain.doFilter(request, response);
        }
    }

    protected abstract void doFilterInternal(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    private boolean canAccess(TenantConfig config) {
        User user;
        try {
            user = AuthUtils.getUser();
        }
        catch (TenantNotFoundException e) {
            return false;
        }
        TenantConfigProvider provider = TenantSupport.get().getConfigProvider();
        return provider.hasAccess(user, config);
    }

    protected Map<String, String> getTenants(boolean all) {
        TenantConfigProvider provider = TenantSupport.get().getConfigProvider();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String first = null;
        for (TenantConfig config : provider.findAll(TenantResolver.CURRENT_HOST.get())) {
            if (config.getActive() == Boolean.FALSE || config.getVisible() == Boolean.FALSE || !all && !this.canAccess(config)) continue;
            if (first == null) {
                first = config.getTenantId();
            }
            map.put(config.getTenantId(), config.getTenantName());
        }
        return map;
    }

    protected Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    protected void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        Cookie cookie = this.getCookie(request, name);
        if (cookie == null) {
            cookie = new Cookie(name, value);
        } else {
            cookie.setValue(value);
        }
        cookie.setHttpOnly(true);
        cookie.setMaxAge(604800);
        response.addCookie(cookie);
    }

    protected static boolean isXHR(ServletRequest request) {
        HttpServletRequest req = (HttpServletRequest)request;
        return "XMLHttpRequest".equals(req.getHeader("X-Requested-With")) || "application/json".equals(req.getHeader("Accept")) || "application/json".equals(req.getHeader("Content-Type"));
    }
}

