/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.tenants;

import com.axelor.common.StringUtils;
import com.axelor.db.tenants.AbstractTenantFilter;
import com.axelor.db.tenants.TenantResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Singleton
public class PreSessionTenantFilter
extends AbstractTenantFilter {
    private static final Set<String> LOGIN_OR_CALLBACK_PAGE = ImmutableSet.of((Object)"/login.jsp", (Object)"/callback");

    private boolean isLoginRequest(HttpServletRequest request) {
        return LOGIN_OR_CALLBACK_PAGE.contains(request.getServletPath());
    }

    private boolean isLoginSubmit(HttpServletRequest request) {
        return this.isLoginRequest(request) && "POST".equalsIgnoreCase(request.getMethod());
    }

    private static String getLoginParam(ServletRequest request, String param) {
        if (!PreSessionTenantFilter.isXHR(request)) {
            return request.getParameter(param);
        }
        try {
            return (String)((Map)new ObjectMapper().readValue((InputStream)request.getInputStream(), Map.class)).get(param);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String currentTenant(ServletRequest request, ServletResponse response) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String tenantId = this.isLoginSubmit(req) ? PreSessionTenantFilter.getLoginParam(request, "tenantId") : null;
        Cookie tenantCookie = this.getCookie(req, "TENANTID");
        if (StringUtils.isBlank((CharSequence)tenantId) && tenantCookie != null) {
            tenantId = tenantCookie.getValue();
        }
        if (this.isLoginRequest(req)) {
            String switchTo;
            HttpSession session = req.getSession();
            Map<String, String> tenants = this.getTenants(true);
            String string = switchTo = !this.isLoginSubmit(req) ? req.getParameter("tenant") : null;
            if (tenants.containsKey(switchTo)) {
                tenantId = switchTo;
            }
            if (!tenants.containsKey(tenantId)) {
                String string2 = tenantId = tenants.isEmpty() ? null : tenants.keySet().iterator().next();
            }
            if (this.isLoginSubmit(req) || !StringUtils.isBlank((CharSequence)switchTo)) {
                if (switchTo != null) {
                    Enumeration attrs = session.getAttributeNames();
                    while (attrs.hasMoreElements()) {
                        String attr = (String)attrs.nextElement();
                        if (!SESSION_KEY_PREFIX_KEEP_LIST.stream().noneMatch(attr::startsWith)) continue;
                        session.removeAttribute(attr);
                    }
                }
                this.setCookie(req, res, "TENANTID", tenantId);
            }
            session.setAttribute("tenantMap", tenants);
            session.setAttribute("tenantId", (Object)tenantId);
        }
        return StringUtils.isBlank((CharSequence)tenantId) ? null : tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        TenantResolver.CURRENT_HOST.set(req.getHeader("Host"));
        TenantResolver.CURRENT_TENANT.set(this.currentTenant(request, response));
        try {
            chain.doFilter(request, response);
        }
        finally {
            TenantResolver.CURRENT_HOST.remove();
            TenantResolver.CURRENT_TENANT.remove();
        }
    }

    @Override
    public void destroy() {
        TenantResolver.CURRENT_HOST.remove();
        TenantResolver.CURRENT_TENANT.remove();
    }
}

