/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.db.tenants;

import com.axelor.db.tenants.TenantModule;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;

public class TenantResolver
implements CurrentTenantIdentifierResolver {
    static final ThreadLocal<String> CURRENT_HOST = new ThreadLocal();
    static final ThreadLocal<String> CURRENT_TENANT = new ThreadLocal();
    private static boolean enabled;

    public TenantResolver() {
        enabled = TenantModule.isEnabled();
    }

    public static String currentTenantIdentifier() {
        if (!enabled) {
            return null;
        }
        String tenant = CURRENT_TENANT.get();
        if (tenant == null) {
            return "default";
        }
        return tenant;
    }

    public String resolveCurrentTenantIdentifier() {
        return TenantResolver.currentTenantIdentifier();
    }

    public boolean validateExistingCurrentSessions() {
        return true;
    }
}

