/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.dms.db.repo;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.User;
import com.axelor.common.Inflector;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.JpaRepository;
import com.axelor.db.JpaSecurity;
import com.axelor.db.Model;
import com.axelor.db.annotations.Track;
import com.axelor.db.mapper.Mapper;
import com.axelor.dms.db.DMSFile;
import com.axelor.dms.db.DMSFileTag;
import com.axelor.dms.db.DMSPermission;
import com.axelor.dms.db.repo.DMSPermissionRepository;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailMessage;
import com.axelor.mail.db.repo.MailMessageRepository;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaAttachment;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaAttachmentRepository;
import com.axelor.rpc.Resource;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.JPQLFilter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.persistence.PersistenceException;
import org.apache.shiro.authz.UnauthorizedException;

public class DMSFileRepository
extends JpaRepository<DMSFile> {
    @Inject
    private MetaFiles metaFiles;
    @Inject
    private JpaSecurity security;
    @Inject
    private DMSPermissionRepository dmsPermissions;
    @Inject
    private MetaAttachmentRepository attachments;
    private static final Pattern previewSupportedPattern = Pattern.compile("\\b(?:pdf|image)\\b");

    public DMSFileRepository() {
        super(DMSFile.class);
    }

    @Nullable
    public DMSFile findHomeByRelated(Model related) {
        return (DMSFile)this.all().filter("COALESCE(self.isDirectory, FALSE) = TRUE AND self.relatedId = :id AND self.relatedModel = :model AND self.parent.relatedModel = :model AND COALESCE(self.parent.relatedId, 0) = 0").bind("id", related.getId()).bind("model", related.getClass().getName()).fetchOne();
    }

    private Model findRelated(DMSFile file) {
        if (file == null || file.getRelatedId() == null || file.getRelatedModel() == null) {
            return null;
        }
        Class<?> klass = null;
        try {
            klass = Class.forName(file.getRelatedModel());
        }
        catch (Exception e) {
            return null;
        }
        Object entity = JpaRepository.of(klass).find(file.getRelatedId());
        return (Model)EntityHelper.getEntity(entity);
    }

    private void createMessage(DMSFile file, boolean delete) {
        Model related = this.findRelated(file);
        if (related == null || related.getId() == null || file.getMetaFile() == null) {
            return;
        }
        Class<Model> klass = EntityHelper.getEntityClass(related);
        Track track = klass.getAnnotation(Track.class);
        if (track == null || !track.files()) {
            return;
        }
        ObjectMapper objectMapper = Beans.get(ObjectMapper.class);
        MailMessageRepository messages = Beans.get(MailMessageRepository.class);
        MailMessage message = new MailMessage();
        message.setRelatedId(related.getId());
        message.setRelatedModel(klass.getName());
        message.setAuthor(AuthUtils.getUser());
        message.setSubject(delete ? I18n.get("File removed") : I18n.get("File added"));
        HashMap<String, List<Map>> json = new HashMap<String, List<Map>>();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("id", file.getMetaFile().getId());
        attrs.put("fileName", file.getFileName());
        attrs.put("fileIcon", this.metaFiles.fileTypeIcon(file.getMetaFile()));
        json.put("files", Arrays.asList(attrs));
        try {
            message.setBody(objectMapper.writeValueAsString(json));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        messages.save(message);
    }

    @Override
    public DMSFile save(DMSFile entity) {
        boolean isAttachment;
        DMSFile parent = entity.getParent();
        Model related = this.findRelated(entity);
        if (related == null && parent != null) {
            related = this.findRelated(parent);
        }
        boolean bl = isAttachment = related != null && entity.getMetaFile() != null;
        if (related != null) {
            entity.setRelatedId(related.getId());
            entity.setRelatedModel(related.getClass().getName());
        }
        if (isAttachment) {
            MetaAttachment attachment;
            MetaAttachment attachmentOld = (MetaAttachment)this.attachments.all().filter("self.metaFile.id = ?", entity.getMetaFile().getId()).fetchOne();
            if (attachmentOld != null) {
                this.attachments.remove(attachmentOld);
            }
            if ((attachment = (MetaAttachment)this.attachments.all().filter("self.metaFile.id = ? AND self.objectId = ? AND self.objectName = ?", entity.getMetaFile().getId(), related.getId(), related.getClass().getName()).fetchOne()) == null) {
                attachment = this.metaFiles.attach(entity.getMetaFile(), related);
                this.attachments.save(attachment);
            }
            this.createMessage(entity, false);
        }
        if (parent == null && related != null) {
            DMSFile dmsHome = this.findOrCreateHome(related);
            entity.setParent(dmsHome);
        }
        if (entity.getVersion() == null || entity.getVersion() == 0) {
            this.copyParentPermissions(entity);
        }
        return super.save(entity);
    }

    private void copyParentPermissions(DMSFile entity) {
        Optional.ofNullable(entity.getParent()).map(DMSFile::getPermissions).ifPresent(permissions -> permissions.stream().map(permission -> this.dmsPermissions.copy(permission, false)).forEach(entity::addPermission));
    }

    protected DMSFile findOrCreateHome(Model related) {
        DMSFile dmsHome;
        DMSFile dmsRoot;
        ArrayList dmsRootFilters = Lists.newArrayList((Object[])new Filter[]{new JPQLFilter("COALESCE(self.isDirectory, FALSE) = TRUE AND self.relatedModel = :model AND COALESCE(self.relatedId, 0) = 0", new Object[0])});
        DMSFile dmsRootParent = this.getRootParent(related);
        if (dmsRootParent != null) {
            dmsRootFilters.add(new JPQLFilter("self.parent = :rootParent", new Object[0]));
        }
        if ((dmsRoot = Filter.and(dmsRootFilters).build(DMSFile.class).bind("model", related.getClass().getName()).bind("rootParent", dmsRootParent).fetchOne()) == null) {
            Inflector inflector = Inflector.getInstance();
            dmsRoot = new DMSFile();
            dmsRoot.setFileName(inflector.pluralize(inflector.humanize(related.getClass().getSimpleName())));
            dmsRoot.setRelatedModel(related.getClass().getName());
            dmsRoot.setIsDirectory(true);
            dmsRoot.setParent(dmsRootParent);
            dmsRoot = this.save(dmsRoot);
        }
        if ((dmsHome = this.findHomeByRelated(related)) == null) {
            String homeName = null;
            try {
                Mapper mapper = Mapper.of(related.getClass());
                homeName = mapper.getNameField().get(related).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (homeName == null) {
                homeName = Strings.padStart((String)("" + related.getId()), (int)5, (char)'0');
            }
            dmsHome = new DMSFile();
            dmsHome.setFileName(homeName);
            dmsHome.setRelatedId(related.getId());
            dmsHome.setRelatedModel(related.getClass().getName());
            dmsHome.setParent(dmsRoot);
            dmsHome.setIsDirectory(true);
            dmsHome = this.save(dmsHome);
        }
        return dmsHome;
    }

    @Nullable
    protected DMSFile getRootParent(Model related) {
        return null;
    }

    @Override
    public void remove(DMSFile entity) {
        if (entity.getIsDirectory() == Boolean.TRUE) {
            List children = this.all().filter("self.parent.id = ?", entity.getId()).fetch();
            for (DMSFile child : children) {
                if (child == entity) continue;
                this.remove(child);
            }
        }
        if (entity.getMetaFile() != null) {
            MetaFile metaFile = entity.getMetaFile();
            long count = this.attachments.all().filter("self.metaFile = ?", metaFile).count();
            if (count == 1L) {
                MetaAttachment attachment = (MetaAttachment)this.attachments.all().filter("self.metaFile = ?", metaFile).fetchOne();
                this.attachments.remove(attachment);
                this.createMessage(entity, true);
            }
            if ((count = this.all().filter("self.metaFile = ?", metaFile).count()) == 1L) {
                entity.setMetaFile(null);
                try {
                    this.metaFiles.delete(metaFile);
                }
                catch (IOException e) {
                    throw new PersistenceException((Throwable)e);
                }
            }
        }
        super.remove(entity);
    }

    private DMSFile findFrom(Map<String, Object> json) {
        if (json == null || json.get("id") == null) {
            return null;
        }
        Long id = Longs.tryParse((String)json.get("id").toString());
        return (DMSFile)this.find(id);
    }

    private boolean canCreate(DMSFile parent) {
        User user = AuthUtils.getUser();
        Group group = user.getGroup();
        if (parent.getCreatedBy() == user || this.security.hasRole("role.super") || this.security.hasRole("role.admin")) {
            return true;
        }
        if (this.dmsPermissions.all().filter("self.file = :file").bind("file", parent).count() == 0L) {
            return true;
        }
        return this.dmsPermissions.all().filter("self.file = :file AND self.permission.canWrite = true AND (self.user = :user OR self.group = :group)").bind("file", parent).bind("user", user).bind("group", group).autoFlush(false).count() > 0L;
    }

    private boolean canOffline(DMSFile file, User user) {
        return file.getIsDirectory() != Boolean.TRUE && file.getMetaFile() != null && this.dmsPermissions.all().filter("self.file = ? AND self.value = 'OFFLINE' AND self.user = ?", file, user).count() > 0L;
    }

    @Transactional
    public DMSFile setOffline(DMSFile file, boolean offline) {
        Preconditions.checkNotNull((Object)file, (Object)"file can't be null");
        if (file.getIsDirectory() == Boolean.TRUE) {
            return file;
        }
        User user = AuthUtils.getUser();
        boolean canOffline = this.canOffline(file, user);
        if (offline == canOffline) {
            return file;
        }
        if (offline) {
            DMSPermission permission = new DMSPermission();
            permission.setValue("OFFLINE");
            permission.setFile(file);
            permission.setUser(user);
            file.addPermission(permission);
        } else {
            DMSPermission permission = (DMSPermission)this.dmsPermissions.all().filter("self.file = ? AND self.value = 'OFFLINE' AND self.user = ?", file, user).fetchOne();
            file.removePermission(permission);
            this.dmsPermissions.remove(permission);
        }
        return this.save(file);
    }

    public List<DMSFile> findOffline(int limit, int offset) {
        return this.all().filter("self.permissions[].value = 'OFFLINE' AND self.permissions[].user = :user").bind("user", AuthUtils.getUser()).fetch(limit, offset);
    }

    @Override
    public Map<String, Object> validate(Map<String, Object> json, Map<String, Object> context) {
        DMSFile file = this.findFrom(json);
        DMSFile parent = this.findFrom((Map)json.get("parent"));
        if (parent == null) {
            return json;
        }
        if (file != null && file.getParent() == parent) {
            return json;
        }
        if (file == null && !this.canCreate(parent)) {
            throw new UnauthorizedException(I18n.get("You can't create document here."));
        }
        if (file != null && file.getParent() != parent && !this.canCreate(parent)) {
            throw new UnauthorizedException(I18n.get("You can't move document here."));
        }
        return json;
    }

    @Override
    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        DMSFile file = this.findFrom(json);
        if (file == null) {
            return json;
        }
        boolean isFile = file.getIsDirectory() != Boolean.TRUE;
        LocalDateTime dt = file.getUpdatedOn();
        if (dt == null) {
            dt = file.getCreatedOn();
        }
        User user = AuthUtils.getUser();
        MetaFile metaFile = file.getMetaFile();
        boolean canShare = file.getCreatedBy() == user || this.security.isPermitted(JpaSecurity.AccessType.CREATE, DMSFile.class, file.getId()) || this.dmsPermissions.all().filter("self.file = ? AND self.value = 'FULL' AND (self.user = ? OR self.group = ?)", file, user, user.getGroup()).count() > 0L;
        json.put("typeIcon", isFile ? "fa fa-file" : "fa fa-folder");
        json.put("downloadIcon", "fa fa-download");
        json.put("detailsIcon", "fa fa-info-circle");
        json.put("canShare", canShare);
        json.put("canWrite", this.canCreate(file));
        if (this.canOffline(file, user)) {
            json.put("offline", true);
        }
        json.put("createdBy", Resource.toMapCompact(file.getCreatedBy()));
        json.put("createdOn", file.getCreatedOn());
        json.put("updatedBy", Resource.toMapCompact(file.getUpdatedBy()));
        json.put("updatedOn", dt);
        if ("html".equals(file.getContentType())) {
            json.put("fileType", "text/html");
            json.put("contentType", "html");
            json.put("typeIcon", "fa fa-file-text-o");
        }
        if ("spreadsheet".equals(file.getContentType())) {
            json.put("fileType", "text/json");
            json.put("contentType", "spreadsheet");
            json.put("typeIcon", "fa fa-file-excel-o");
        }
        if (metaFile != null) {
            String fileType = metaFile.getFileType();
            String fileIcon = this.metaFiles.fileTypeIcon(metaFile);
            json.put("fileType", fileType);
            json.put("typeIcon", "fa fa-colored " + fileIcon);
            json.put("metaFile.sizeText", metaFile.getSizeText());
            if (StringUtils.notBlank((CharSequence)fileType) && previewSupportedPattern.matcher(fileType).find()) {
                json.put("inlineUrl", String.format("ws/dms/inline/%d", file.getId()));
            }
        }
        if (file.getTags() != null) {
            ArrayList<Map<String, Object>> tags = new ArrayList<Map<String, Object>>();
            for (DMSFileTag tag : file.getTags()) {
                tags.add(Resource.toMap(tag, "id", "code", "name", "style"));
            }
            json.put("tags", tags);
        }
        return json;
    }
}

