/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.dms.db.repo;

import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.PermissionRepository;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.Query;
import com.axelor.db.internal.DBHelper;
import com.axelor.dms.db.DMSFile;
import com.axelor.dms.db.DMSPermission;
import com.axelor.i18n.I18n;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.PersistenceException;

public class DMSPermissionRepository
extends JpaRepository<DMSPermission> {
    @Inject
    private PermissionRepository perms;

    public DMSPermissionRepository() {
        super(DMSPermission.class);
    }

    private Permission findOrCreate(String name, String ... args) {
        Permission perm = this.perms.findByName(name);
        if (perm == null) {
            perm = new Permission();
            perm.setName(name);
            perm.setCondition(args.length > 0 ? args[0] : null);
            perm.setConditionParams(args.length > 1 ? args[1] : null);
            perm.setObject(args.length > 2 ? args[2] : DMSFile.class.getName());
            perm = this.perms.save(perm);
        }
        return perm;
    }

    private Permission findOrCreateRead() {
        Permission permission = this.findOrCreate("perm.dms.file.__read__", "self.id = ANY(SELECT x.id FROM DMSFile x LEFT JOIN x.permissions x_permissions LEFT JOIN x_permissions.user x_permissions_user LEFT JOIN x_permissions.group x_permissions_group LEFT JOIN x_permissions.permission x_permissions_permission WHERE (x_permissions_user = ? OR x_permissions_group = ?) AND x_permissions_permission.canRead = true)", "__user__, __user__.group");
        permission.setCanCreate(false);
        permission.setCanRead(true);
        permission.setCanWrite(false);
        permission.setCanRemove(false);
        return permission;
    }

    @Override
    public DMSPermission save(DMSPermission entity) {
        DMSFile file = entity.getFile();
        if (file == null) {
            throw new PersistenceException(I18n.get("Invalid permission"));
        }
        User user = entity.getUser();
        Group group = entity.getGroup();
        Permission permission = null;
        Permission __read__ = this.findOrCreateRead();
        switch (entity.getValue()) {
            case "FULL": {
                permission = this.findOrCreate("perm.dms.file.__full__", "self.id = ANY(SELECT x.id FROM DMSFile x LEFT JOIN x.permissions x_permissions LEFT JOIN x_permissions.user x_permissions_user LEFT JOIN x_permissions.group x_permissions_group LEFT JOIN x_permissions.permission x_permissions_permission WHERE (x_permissions_user = ? OR x_permissions_group = ?) AND x_permissions_permission.canCreate = true)", "__user__, __user__.group");
                permission.setCanCreate(true);
                permission.setCanRead(true);
                permission.setCanWrite(true);
                permission.setCanRemove(true);
                break;
            }
            case "WRITE": {
                permission = this.findOrCreate("perm.dms.file.__write__", "self.id = ANY(SELECT x.id FROM DMSFile x LEFT JOIN x.permissions x_permissions LEFT JOIN x_permissions.user x_permissions_user LEFT JOIN x_permissions.group x_permissions_group LEFT JOIN x_permissions.permission x_permissions_permission WHERE (x_permissions_user = ? OR x_permissions_group = ?) AND x_permissions_permission.canWrite = true)", "__user__, __user__.group");
                permission.setCanCreate(false);
                permission.setCanRead(true);
                permission.setCanWrite(true);
                permission.setCanRemove(true);
                break;
            }
            case "READ": {
                permission = __read__;
            }
        }
        if (permission == null) {
            return super.save(entity);
        }
        Permission __self__ = this.findOrCreate("perm.dms.file.__self__", "self.createdBy = ?", "__user__", DMSFile.class.getName());
        Permission __create__ = this.findOrCreate("perm.dms.__create__", null, null, "com.axelor.dms.db.*");
        Permission __meta__ = this.findOrCreate("perm.meta.file.__create__", null, null, "com.axelor.meta.db.MetaFile");
        Permission __perm_full__ = this.findOrCreate("perm.dms.perm.__full__", "self.createdBy = ? OR ((self.user = ? OR self.group = ?) AND self.value = 'FULL')", "__user__, __user__, __user__.group", DMSPermission.class.getName());
        __perm_full__.setCanCreate(true);
        __perm_full__.setCanRead(true);
        __perm_full__.setCanWrite(true);
        __perm_full__.setCanRemove(true);
        __self__.setCanCreate(false);
        __self__.setCanRead(true);
        __self__.setCanWrite(true);
        __self__.setCanRemove(true);
        __create__.setCanCreate(true);
        __create__.setCanRead(false);
        __create__.setCanWrite(false);
        __create__.setCanRemove(false);
        __meta__.setCanCreate(true);
        __meta__.setCanRead(false);
        __meta__.setCanWrite(false);
        __meta__.setCanRemove(false);
        if (user != null) {
            user.addPermission(permission);
            user.addPermission(__read__);
            user.addPermission(__create__);
            user.addPermission(__meta__);
            user.addPermission(__perm_full__);
        }
        if (group != null) {
            group.addPermission(permission);
            group.addPermission(__read__);
            group.addPermission(__create__);
            group.addPermission(__meta__);
            group.addPermission(__perm_full__);
        }
        entity.setPermission(permission);
        int version = entity.getVersion();
        entity = super.save(entity);
        this.applyPermissionToParents(entity, __read__);
        if (file.getIsDirectory().booleanValue() && entity.getVersion() > version) {
            this.applySamePermissionToChildren(entity);
        }
        return entity;
    }

    @Override
    public void remove(DMSPermission entity) {
        this.recursiveRemoveHavingSamePermission(entity);
    }

    private void applyPermissionToParents(DMSPermission entity, Permission permission) {
        for (DMSFile parentFile = entity.getFile().getParent(); parentFile != null; parentFile = parentFile.getParent()) {
            if (this.filterPermission(parentFile.getPermissions(), entity).findFirst().isPresent()) continue;
            DMSPermission dmsPermission = new DMSPermission();
            dmsPermission.setUser(entity.getUser());
            dmsPermission.setGroup(entity.getGroup());
            dmsPermission.setValue("READ");
            dmsPermission.setPermission(permission);
            dmsPermission.setFile(parentFile);
            JPA.em().persist((Object)dmsPermission);
        }
    }

    private void applySamePermissionToChildren(DMSPermission entity) {
        int valueLevel = this.getValueLevel(entity);
        ArrayList existingPermissionIds = new ArrayList();
        ArrayList createPermissionFileIds = new ArrayList();
        this.processDMSFileChildren(entity, files -> files.forEach(file -> {
            DMSPermission basePermission = (DMSPermission)this.find(entity.getId());
            Optional<DMSPermission> existingPermissionOpt = this.filterPermission(file.getPermissions(), basePermission).findFirst();
            if (existingPermissionOpt.isPresent()) {
                DMSPermission existingPermission = existingPermissionOpt.get();
                if (this.getValueLevel(existingPermission) < valueLevel) {
                    existingPermissionIds.add(existingPermission.getId());
                }
            } else {
                createPermissionFileIds.add(file.getId());
            }
        }));
        if (!existingPermissionIds.isEmpty()) {
            JPA.em().createQuery("UPDATE DMSPermission self SET self.value = :value WHERE self.id IN (:existingPermissionIds)").setParameter("value", (Object)entity.getValue()).setParameter("existingPermissionIds", existingPermissionIds).executeUpdate();
        }
        if (!createPermissionFileIds.isEmpty()) {
            DMSPermission basePermission = (DMSPermission)this.find(entity.getId());
            JpaRepository.of(DMSFile.class).all().filter("self.id IN (:createPermissionFileIds)").bind("createPermissionFileIds", createPermissionFileIds).fetchStream().forEach(file -> {
                DMSPermission permission = this.copy(basePermission, false);
                permission.setFile((DMSFile)file);
                JPA.em().persist((Object)permission);
            });
        }
    }

    private void recursiveRemoveHavingSamePermission(DMSPermission entity) {
        JpaRepository<DMSFile> dmsFileRepo = JpaRepository.of(DMSFile.class);
        ArrayList entityIds = Lists.newArrayList((Object[])new Long[]{entity.getId()});
        for (DMSFile parentFile = entity.getFile().getParent(); parentFile != null; parentFile = parentFile.getParent()) {
            if (!dmsFileRepo.all().filter("self.parent = :parent AND self != :baseFile AND (self.permissions.user = :user OR self.permissions.group = :group)").bind("parent", parentFile).bind("baseFile", entity.getFile()).bind("user", entity.getUser()).bind("group", entity.getGroup()).fetch(1).isEmpty()) continue;
            this.filterPermission(parentFile.getPermissions(), entity).map(DMSPermission::getId).forEach(entityIds::add);
        }
        if (entity.getFile() != null && entity.getFile().getIsDirectory().booleanValue()) {
            this.processDMSFileChildren(entity, files -> {
                DMSPermission basePermission = (DMSPermission)this.find(entity.getId());
                files.forEach(file -> this.filterPermission(file.getPermissions(), basePermission).map(DMSPermission::getId).forEach(entityIds::add));
            });
        }
        JPA.em().createQuery("DELETE FROM DMSPermission self WHERE self.id IN (:entityIds)").setParameter("entityIds", (Object)entityIds).executeUpdate();
    }

    private void processDMSFileChildren(DMSPermission entity, Consumer<List<DMSFile>> processor) {
        JpaRepository<DMSFile> dmsFileRepo = JpaRepository.of(DMSFile.class);
        ArrayDeque<Long> parentIds = new ArrayDeque<Long>();
        parentIds.add(entity.getFile().getId());
        while (!parentIds.isEmpty()) {
            List<DMSFile> results;
            Long parentId = (Long)parentIds.remove();
            Query<DMSFile> query = dmsFileRepo.all().filter("self.parent.id = :parentId").bind("parentId", parentId).order("id");
            int offset = 0;
            while (!(results = query.fetch(DBHelper.getJdbcFetchSize(), offset)).isEmpty()) {
                processor.accept(results);
                results.stream().filter(DMSFile::getIsDirectory).map(DMSFile::getId).forEach(parentIds::add);
                offset += results.size();
                JPA.flush();
                JPA.clear();
            }
        }
    }

    private Stream<DMSPermission> filterPermission(List<DMSPermission> permissions, DMSPermission basePermission) {
        return Optional.ofNullable(permissions).orElse(Collections.emptyList()).stream().filter(permission -> permission.getUser() != null && Objects.equals(permission.getUser(), basePermission.getUser()) || permission.getGroup() != null && Objects.equals(permission.getGroup(), basePermission.getGroup()));
    }

    private int getValueLevel(DMSPermission entity) {
        return (Integer)ImmutableMap.of((Object)"READ", (Object)1, (Object)"WRITE", (Object)2, (Object)"FULL", (Object)3).getOrDefault((Object)entity.getValue(), (Object)0);
    }
}

